/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import java.util.LinkedList;
import java.util.List;

public abstract class HostVipBaseAction
extends Action {
    protected final Result processVips(WorkItem workItem) {
        List<Vip> vips = this.dataAccess.getVips(workItem.getService().serviceId);
        if (vips == null || vips.isEmpty()) {
            return Result.success;
        }
        Result result = Result.success;
        LinkedList<Vip> successVips = new LinkedList<Vip>();
        for (Vip vip : vips) {
            if (!vip.getModuleId().equals(workItem.getMainModule().moduleId) || !vip.getEnvironment().equals(workItem.getHost().environment)) continue;
            result = this.processVip(workItem, vip);
            if (result == Result.error) {
                this.updateStatusFailure(workItem);
                this.recordAudit(workItem, result, successVips, vip);
                return result;
            }
            successVips.add(vip);
        }
        this.recordAudit(workItem, result, successVips, null);
        return result;
    }

    protected abstract Result processVip(WorkItem var1, Vip var2);

    private void updateStatusFailure(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "Failed to " + this.getVerb() + " host " + this.getPreposition() + " VIP");
    }

    private void recordAudit(WorkItem workItem, Result result, List<Vip> successVips, Vip failedVip) {
        String output = null;
        if (successVips == null || successVips.isEmpty()) {
            output = failedVip == null ? "No VIPs to " + this.getVerb() : "Failed to " + this.getVerb() + " host " + this.getPreposition() + " VIP " + failedVip.getDns();
        } else {
            output = "VIPs successfully " + this.getVerbPastTense() + ":\n";
            for (Vip vip : successVips) {
                output = output + " - " + vip.getDns() + "\n";
            }
            if (failedVip != null) {
                output = "Failed to " + this.getVerb() + " host " + this.getPreposition() + " VIP " + failedVip.getDns();
            }
        }
        this.writeAudit(workItem, result, null, output);
    }

    protected abstract String getVerb();

    protected abstract String getVerbPastTense();

    protected abstract String getPreposition();
}

