/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.google.gson.Gson;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.dao.SmokeTestData;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSmokeTestAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostSmokeTestAction.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmokeTestData ExecuteSmokeTest(String smokeTestUrl, String endPoint, Parameters parameters, Gson gson, OkHttpClient client) {
        if (smokeTestUrl == null) return null;
        if (smokeTestUrl.isEmpty()) return null;
        if (endPoint == null) return null;
        if (endPoint.isEmpty()) {
            return null;
        }
        LOGGER.info("Smoke testing EP {} with {}", (Object)endPoint, (Object)smokeTestUrl);
        String url = "http://" + smokeTestUrl.replace("{endPoint}", endPoint);
        try {
            Request request;
            Response response;
            Request.Builder builder = new Request.Builder().url(url);
            if (parameters.getUsername() != null && parameters.getUsername().isEmpty() && parameters.getPassword() != null && parameters.getPassword().isEmpty()) {
                builder.addHeader("Authorization", Credentials.basic((String)parameters.getUsername(), (String)parameters.getPassword()));
            }
            if (!(response = client.newCall(request = builder.build()).execute()).isSuccessful()) {
                LOGGER.warn("Call to {} failed with code {}", (Object)url, (Object)response.code());
                return null;
            }
            try (InputStream stream = response.body().byteStream();){
                InputStreamReader reader = new InputStreamReader(stream);
                SmokeTestData smokeTestData = (SmokeTestData)gson.fromJson((Reader)reader, SmokeTestData.class);
                return smokeTestData;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Call to {} failed with exception {}", (Object)url, (Object)ex.getMessage());
            return null;
        }
    }

    @Override
    public void updateStatus(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being smoke tested", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, true, "Smoke Testing...");
    }

    @Override
    public Result process(WorkItem workItem) {
        Result result;
        String smokeTestUrl = workItem.getMainModule().smokeTestUrl;
        if (smokeTestUrl == null || smokeTestUrl.isEmpty()) {
            return Result.success;
        }
        SmokeTestData smokeTestData = HostSmokeTestAction.ExecuteSmokeTest(smokeTestUrl, workItem.getHost().hostName, this.parameters, this.gson, this.client);
        String output = null;
        if (smokeTestData == null) {
            result = Result.error;
        } else if (smokeTestData.result == null || smokeTestData.result.isEmpty() || !smokeTestData.result.equalsIgnoreCase("PASS")) {
            result = Result.error;
            output = smokeTestData.output;
        } else {
            result = Result.success;
            output = smokeTestData.output;
        }
        this.writeAudit(workItem, result, null, output);
        return result;
    }

    @Override
    public void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being smoke tested", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(host.getHostId(), false, "-");
    }

    @Override
    public void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being smoke tested", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "Last smoke test failed");
    }
}

