/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostRestartAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostRestartAction.class);

    @Override
    public void updateStatus(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, true, "Restarting...");
    }

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Restarting host {} of {}", (Object)workItem.getHost().hostName, (Object)workItem.getService().serviceName);
        return Result.success;
    }

    @Override
    public void recordAudit(WorkItem workItem, Map<String, String> notes, Result result, String output) {
        notes.put("Reason", workItem.getReason());
        notes.put("Check for OS Upgrade", Boolean.toString(workItem.getHost().doOsUpgrade));
        this.writeAudit(workItem, result, notes, output);
    }

    @Override
    public void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "-");
    }

    @Override
    public void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being restarted", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "Last restart failed");
    }
}

