/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDeployAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostDeployAction.class);

    @Override
    public void updateStatus(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being deployed too", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, true, "Deploying...");
    }

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Deploying to host {} of {}", (Object)workItem.getHost().hostName, (Object)workItem.getService().serviceName);
        return Result.success;
    }

    @Override
    public void recordAudit(WorkItem workItem, Map<String, String> notes, Result result, String output) {
        if (workItem.getHost().version != null) {
            notes.put("Version", workItem.getHost().version);
        }
        if (workItem.getHost().prevVersion != null) {
            notes.put("Prev Version", workItem.getHost().prevVersion);
        }
        if (workItem.getHost().versionUrl != null) {
            notes.put("Version Url", workItem.getHost().versionUrl);
        }
        if (workItem.getHost().configVersion != null) {
            notes.put("Config_Version", workItem.getHost().configVersion);
        }
        notes.put("Reason", workItem.getReason());
        this.writeAudit(workItem, result, notes, output);
    }

    @Override
    public void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being deployed too", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "-");
    }

    @Override
    public void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being deployed too", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "Last deployment failed");
    }
}

