/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostCreateAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostCreateAction.class);

    @Override
    public void updateStatus(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, true, "Creating...");
    }

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Creating host {} for {}", (Object)workItem.getHost().hostName, (Object)workItem.getService().serviceName);
        return Result.success;
    }

    @Override
    public void recordAudit(WorkItem workItem, Map<String, String> notes, Result result, String output) {
        notes.put("DC", workItem.getHost().dataCenter);
        notes.put("Environment", workItem.getHost().environment);
        notes.put("Platform", workItem.getHost().platform);
        notes.put("Size_CPU", Integer.toString(workItem.getHost().sizeCpu));
        notes.put("Size_Memory", Integer.toString(workItem.getHost().sizeMemory));
        notes.put("Size_Storage", Integer.toString(workItem.getHost().sizeStorage));
        notes.put("Reason", workItem.getReason());
        this.writeAudit(workItem, result, notes, output);
    }

    @Override
    public void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(host.getHostId(), false, "-");
    }

    @Override
    public void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being created", (Object)workItem.getHost().hostId);
            return;
        }
        LOGGER.warn("Deleting host record due to failure in creating host {]", (Object)host.getHostId());
        this.dataAccess.deleteHost(host);
        this.dataAccess.deleteSearch("hostName", host.getHostName());
    }
}

