/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import com.squareup.okhttp.OkHttpClient;
import java.util.Map;

public abstract class Action {
    private String name;
    protected DataAccess dataAccess;
    protected Parameters parameters;
    protected ConfigHelper configHelper;
    protected OkHttpClient client;
    protected Gson gson;

    public final void init(String name, DataAccess dataAccess, Parameters parameters, ConfigHelper configHelper, OkHttpClient client, Gson gson) {
        this.name = name;
        this.dataAccess = dataAccess;
        this.parameters = parameters;
        this.configHelper = configHelper;
        this.client = client;
        this.gson = gson;
    }

    public String getName() {
        return this.name;
    }

    public void updateStatus(WorkItem workItem) {
    }

    public abstract Result process(WorkItem var1);

    public Result processCallback(WorkItem workItem, CallbackData callbackData) {
        throw new UnsupportedOperationException("Work item " + this.name + " does not supported callbacks.");
    }

    public void recordAudit(WorkItem workItem, Map<String, String> notes, Result result, String output) {
        this.writeAudit(workItem, result, notes, output);
    }

    public void success(WorkItem workItem) {
    }

    public void error(WorkItem workItem) {
    }

    protected void writeAudit(WorkItem workItem, Result result, Map<String, String> notes, String output) {
        Audit audit = new Audit();
        audit.serviceId = workItem.getService().serviceId;
        audit.setTimePerformed(GMT.getGmtAsDate());
        audit.timeRequested = workItem.getRequestDate();
        audit.requestor = workItem.getUsername();
        audit.type = workItem.getType();
        audit.operation = workItem.getOperation();
        boolean bl = audit.successfull = result == Result.success;
        if (workItem.getMainModule() != null) {
            audit.moduleName = workItem.getMainModule().moduleName;
        }
        if (workItem.getHost() != null) {
            audit.hostName = workItem.getHost().hostName;
        }
        if (workItem.getVip() != null) {
            audit.vipName = workItem.getVip().dns;
        }
        audit.notes = notes == null || notes.isEmpty() ? "" : this.gson.toJson(notes);
        this.dataAccess.saveAudit(audit, output);
    }

    protected String getGitUrl(WorkItem workItem) {
        String gitUrl = this.parameters.getString("gitPathUrl", "git@github.com:{group}/{project}.git");
        gitUrl = gitUrl.replace("{group}", workItem.getTeam().gitGroup);
        gitUrl = gitUrl.replace("{project}", workItem.getService().gitProject);
        return gitUrl;
    }
}

