/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.schedule;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.messaging.MessageType;
import com.northernwall.hadrian.messaging.MessagingCoodinator;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.action.HostSmokeTestAction;
import com.northernwall.hadrian.workItem.dao.SmokeTestData;
import com.squareup.okhttp.OkHttpClient;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmokeTestRunner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmokeTestRunner.class);
    private final Service service;
    private final Module module;
    private final int group;
    private final DataAccess dataAccess;
    private final Parameters parameters;
    private final Gson gson;
    private final OkHttpClient client;
    private final MessagingCoodinator messagingCoodinator;

    public SmokeTestRunner(Service service, Module module, int group, DataAccess dataAccess, Parameters parameters, Gson gson, OkHttpClient client, MessagingCoodinator messagingCoodinator) {
        this.service = service;
        this.module = module;
        this.group = group;
        this.dataAccess = dataAccess;
        this.parameters = parameters;
        this.gson = gson;
        this.client = client;
        this.messagingCoodinator = messagingCoodinator;
    }

    @Override
    public void run() {
        MessageType messageType;
        LOGGER.info("Running scheduled smoke test for {} {} in group {}", new Object[]{this.service.getServiceName(), this.module.getModuleName(), this.group});
        List<Host> hosts = this.dataAccess.getHosts(this.service.getServiceId());
        LinkedList<Host> failedHosts = new LinkedList<Host>();
        if (hosts != null && !hosts.isEmpty()) {
            for (Host host : hosts) {
                if (!host.getModuleId().equals(this.module.getModuleId())) continue;
                SmokeTestData smokeTestData = HostSmokeTestAction.ExecuteSmokeTest(this.module.getSmokeTestUrl(), host.getHostName(), this.parameters, this.gson, this.client);
                if (smokeTestData == null || smokeTestData.result == null || smokeTestData.result.isEmpty() || !smokeTestData.result.equalsIgnoreCase("pass")) {
                    LOGGER.info("Scheduled smoke test failed for {} in {} in group {}", new Object[]{host.getHostName(), this.service.getServiceName(), this.group});
                    failedHosts.add(host);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!failedHosts.isEmpty() && (messageType = this.messagingCoodinator.getMessageType("failedSmokeTest")) != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("count", Integer.toString(failedHosts.size()));
            data.put("host", this.JoinHosts(failedHosts));
            Team team = this.dataAccess.getTeam(this.service.getTeamId());
            this.messagingCoodinator.sendMessage(messageType, team, this.service, data);
        }
    }

    private String JoinHosts(List<Host> failedHosts) {
        String hostNames = "";
        int size = failedHosts.size();
        switch (size) {
            case 1: {
                hostNames = failedHosts.get(0).getHostName();
                break;
            }
            case 2: {
                hostNames = failedHosts.get(0).getHostName() + " and " + failedHosts.get(1).getHostName();
                break;
            }
            default: {
                for (int i = 0; i < size - 1; ++i) {
                    hostNames = hostNames + failedHosts.get(0).getHostName() + ", ";
                }
                hostNames = hostNames + " and " + failedHosts.get(size - 1).getHostName();
            }
        }
        return hostNames;
    }
}

