/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.schedule;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.handlers.utility.HealthWriter;
import com.northernwall.hadrian.messaging.MessagingCoodinator;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.schedule.Leader;
import com.northernwall.hadrian.schedule.ScheduleRunner;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dsh.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scheduler.class);
    public static final int THREAD_COUNT = 25;
    public static final int GROUP_COUNT = 10;
    private final Leader leader;
    private final ScheduledExecutorService scheduledExecutorService;
    private final List<ScheduleRunner> runners;

    public Scheduler(DataAccess dataAccess, MetricRegistry metricRegistry, Leader leader, Parameters parameters, OkHttpClient client, MessagingCoodinator messagingCoodinator) {
        Gson gson = new Gson();
        this.leader = leader;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(25);
        this.runners = new LinkedList<ScheduleRunner>();
        for (int group = 0; group < 10; ++group) {
            ScheduleRunner runner = new ScheduleRunner(group, dataAccess, metricRegistry, leader, parameters, gson, client, messagingCoodinator, this.scheduledExecutorService);
            this.runners.add(runner);
            this.scheduledExecutorService.scheduleWithFixedDelay(runner, 5L, 5L, TimeUnit.MINUTES);
        }
        LOGGER.info("Scheduler started with {} groups and using {}", (Object)10, (Object)leader.getClass().getSimpleName());
    }

    public void getHealth(HealthWriter writer) throws IOException {
        writer.addStringLine("Scheduler Leader", this.leader.getClass().getSimpleName());
        for (ScheduleRunner runner : this.runners) {
            runner.getHealth(writer);
        }
    }
}

