/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.module.maven;

import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.module.ModuleArtifactHelper;
import com.northernwall.hadrian.module.SematicVersionComparator;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenHelper
implements ModuleArtifactHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenHelper.class);
    private final OkHttpClient client;
    protected final Parameters parameters;
    private final SematicVersionComparator mavenVersionComparator;

    public MavenHelper(Parameters parameters, OkHttpClient client) {
        this.parameters = parameters;
        this.mavenVersionComparator = new SematicVersionComparator();
        this.client = client;
    }

    @Override
    public List<String> readArtifactVersions(Service service, Module module) {
        List<String> versions = new LinkedList<String>();
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && module.getMavenArtifactId() != null && !module.getMavenArtifactId().isEmpty()) {
            try {
                Request.Builder builder = new Request.Builder();
                String mavenRepo = this.parameters.getString("maven.http.url", "http://127.0.0.1/mvnrepo/internal/");
                String url = mavenRepo + service.getMavenGroupId().replace(".", "/") + "/" + module.getMavenArtifactId() + "/maven-metadata.xml";
                builder.url(url);
                String mavenUsername = this.parameters.getString("maven.http.username", "-");
                String mavenPassword = this.parameters.getString("maven.http.password", "-");
                if (!mavenUsername.equals("-")) {
                    String credential = Credentials.basic((String)mavenUsername, (String)mavenPassword);
                    builder.header("Authorization", credential);
                }
                Request request = builder.build();
                Response response = this.client.newCall(request).execute();
                try (InputStream inputStream = response.body().byteStream();){
                    versions = this.processMavenStream(inputStream);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error reading maven version from {} {}, {}", new Object[]{service.getMavenGroupId(), module.getMavenArtifactId(), ex.getMessage()});
            }
        }
        return versions;
    }

    private List<String> processMavenStream(InputStream inputStream) throws Exception {
        LinkedList<String> versions = new LinkedList<String>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        Element root = doc.getDocumentElement();
        Node versionsNode = root.getElementsByTagName("versions").item(0);
        for (int i = 0; i < versionsNode.getChildNodes().getLength(); ++i) {
            Node child = versionsNode.getChildNodes().item(i);
            if (child.getNodeType() != 1 || child.getTextContent().endsWith("SNAPSHOT")) continue;
            versions.add(child.getTextContent());
        }
        Collections.sort(versions, this.mavenVersionComparator);
        int maxMavenVersions = this.parameters.getInt("maven.maxVersions", 15);
        if (versions.size() > maxMavenVersions) {
            return versions.subList(0, maxMavenVersions);
        }
        return versions;
    }
}

