/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.messaging;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.messaging.MessageType;
import com.northernwall.hadrian.messaging.MessagingCoodinator;
import com.northernwall.hadrian.messaging.dao.PostMessageData;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class MessageSendHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final MessagingCoodinator messagingCoodinator;

    public MessageSendHandler(DataAccess dataAccess, AccessHelper accessHelper, MessagingCoodinator messagingCoodinator) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.messagingCoodinator = messagingCoodinator;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostMessageData data = this.fromJson(request, PostMessageData.class);
        MessageType messageType = this.messagingCoodinator.getMessageType(data.messageTypeName);
        if (messageType == null) {
            throw new Http400BadRequestException("Could not find MessageType " + data.messageTypeName);
        }
        if (data.gitGroup != null && !data.gitGroup.isEmpty() && data.gitProject != null && !data.gitProject.isEmpty()) {
            this.processByGit(data, request, messageType);
        } else {
            this.processByService(data, request, messageType);
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void processByGit(PostMessageData data, Request request, MessageType messageType) {
        List<Service> services = this.getDataAccess().getActiveServices();
        for (Team team : this.getDataAccess().getTeams()) {
            if (!team.getGitGroup().equalsIgnoreCase(data.gitGroup)) continue;
            this.accessHelper.checkIfUserCanAudit(request, team);
            List<Service> teamServices = Service.filterTeam(team.getTeamId(), services);
            for (Service service : teamServices) {
                if (!service.getGitProject().equalsIgnoreCase(data.gitProject)) continue;
                this.messagingCoodinator.sendMessage(messageType, team, service, data.data);
                return;
            }
        }
    }

    private void processByService(PostMessageData data, Request request, MessageType messageType) {
        Service service = this.getService(data.serviceId, data.serviceName);
        Team team = this.getDataAccess().getTeam(service.getTeamId());
        this.accessHelper.checkIfUserCanAudit(request, team);
        Module module = this.getModule(null, data.moduleName, service);
        this.messagingCoodinator.sendMessage(messageType, team, service, module, data.data);
    }
}

