/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service.dao;

import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.FindBugsLevel;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.service.dao.GetCustomFunctionData;
import com.northernwall.hadrian.handlers.service.dao.GetDataStoreData;
import com.northernwall.hadrian.handlers.service.dao.GetEnvironmentData;
import com.northernwall.hadrian.handlers.service.dao.GetHostData;
import com.northernwall.hadrian.handlers.service.dao.GetModuleData;
import com.northernwall.hadrian.handlers.service.dao.GetVipData;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class GetServiceData {
    public String serviceId;
    public String serviceName;
    public String teamId;
    public String description;
    public String serviceType;
    public String gitProject;
    public String scope;
    public String mavenGroupId;
    public boolean doBuilds;
    public boolean doDeploys;
    public boolean doManageVip;
    public boolean doCheckJar;
    public FindBugsLevel doFindBugsLevel;
    public String testStyle;
    public String testHostname;
    public String testRunAs;
    public String testDeploymentFolder;
    public String testCmdLine;
    public int testTimeOut;
    public List<Document> leftDocuments;
    public List<Document> middleDocuments;
    public List<Document> rightDocuments;
    public Date creationDate;
    public Date deletionDate;
    public boolean active;
    public List<GetModuleData> modules;
    public List<GetEnvironmentData> environments;
    public List<GetDataStoreData> dataStores;
    public boolean canModify;

    public static GetServiceData create(Service service) {
        GetServiceData temp = new GetServiceData();
        temp.serviceId = service.getServiceId();
        temp.serviceName = service.getServiceName();
        temp.teamId = service.getTeamId();
        temp.description = service.getDescription();
        temp.serviceType = service.getServiceType();
        temp.gitProject = service.getGitProject();
        temp.scope = service.getScope();
        temp.mavenGroupId = service.getMavenGroupId();
        temp.doBuilds = service.isDoBuilds();
        temp.doDeploys = service.isDoDeploys();
        temp.doManageVip = service.isDoManageVip();
        temp.doCheckJar = service.isDoCheckJar();
        temp.doFindBugsLevel = service.getDoFindBugsLevel();
        temp.testStyle = service.getTestStyle();
        temp.testHostname = service.getTestHostname();
        temp.testRunAs = service.getTestRunAs();
        temp.testDeploymentFolder = service.getTestDeploymentFolder();
        temp.testCmdLine = service.getTestCmdLine();
        temp.testTimeOut = service.getTestTimeOut();
        temp.leftDocuments = new LinkedList<Document>();
        temp.middleDocuments = new LinkedList<Document>();
        temp.rightDocuments = new LinkedList<Document>();
        Collections.sort(service.getDocuments());
        for (Document doc : service.getDocuments()) {
            if (temp.middleDocuments.size() == temp.rightDocuments.size()) {
                if (temp.leftDocuments.size() == temp.middleDocuments.size()) {
                    temp.leftDocuments.add(doc);
                    continue;
                }
                temp.middleDocuments.add(doc);
                continue;
            }
            temp.rightDocuments.add(doc);
        }
        temp.creationDate = service.getCreationDate();
        temp.deletionDate = service.getDeletionDate();
        temp.active = service.isActive();
        temp.modules = new LinkedList<GetModuleData>();
        temp.environments = new LinkedList<GetEnvironmentData>();
        temp.dataStores = new LinkedList<GetDataStoreData>();
        return temp;
    }

    public void addEnvironment(String environment) {
        for (GetEnvironmentData environmentData : this.environments) {
            if (!environmentData.environment.equals(environment)) continue;
            return;
        }
        GetEnvironmentData environmentData = new GetEnvironmentData();
        environmentData.environment = environment;
        this.environments.add(environmentData);
    }

    public void addModuleEnvironment(Module module, String environment) {
        for (GetEnvironmentData environmentData : this.environments) {
            if (!environmentData.environment.equals(environment)) continue;
            environmentData.addModule(module);
            return;
        }
    }

    public void addHost(GetHostData hostData, GetModuleData moduleData) {
        for (GetEnvironmentData environmentData : this.environments) {
            if (!environmentData.environment.equals(hostData.environment)) continue;
            environmentData.addHost(hostData, moduleData);
            return;
        }
    }

    public void addVip(GetVipData vipData, GetModuleData moduleData) {
        for (GetEnvironmentData environmentData : this.environments) {
            if (!environmentData.environment.equals(vipData.environment)) continue;
            environmentData.addVip(vipData, moduleData);
            return;
        }
    }

    public void addCustomFunction(GetCustomFunctionData customFunctionData) {
        for (GetModuleData moduleData : this.modules) {
            if (!customFunctionData.moduleId.equals(moduleData.moduleId)) continue;
            moduleData.customFunctions.add(customFunctionData);
        }
        for (GetEnvironmentData environmentData : this.environments) {
            environmentData.addCustomFunction(customFunctionData);
        }
    }
}

