/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.details.VipDetailsHelper;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.GetVipDetailRowData;
import com.northernwall.hadrian.handlers.service.dao.GetVipDetailsData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class VipGetDetailsHandler
extends BasicHandler {
    private final VipDetailsHelper vipDetailsHelper;

    public VipGetDetailsHandler(DataAccess dataAccess, VipDetailsHelper vipDetailsHelper) {
        super(dataAccess);
        this.vipDetailsHelper = vipDetailsHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        boolean found;
        Service service = this.getService(request);
        Vip vip = this.getVip(request, service);
        GetVipDetailsData details = this.vipDetailsHelper.getDetails(vip);
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        for (Host host : hosts) {
            if (!host.getEnvironment().equals(vip.getEnvironment())) continue;
            found = false;
            for (GetVipDetailRowData row : details.rows) {
                if (!host.getHostName().equalsIgnoreCase(row.hostName)) continue;
                found = true;
            }
            if (found) continue;
            GetVipDetailRowData temp = new GetVipDetailRowData();
            temp.hostName = host.getHostName();
            temp.warning = "Host not found in VIP";
            details.rows.add(temp);
        }
        for (GetVipDetailRowData row : details.rows) {
            found = false;
            for (Host host : hosts) {
                if (!host.getHostName().equalsIgnoreCase(row.hostName)) continue;
                found = true;
            }
            if (found) continue;
            row.warning = "Host in VIP, but not in inventory";
        }
        Collections.sort(details.rows, new Comparator<GetVipDetailRowData>(){

            @Override
            public int compare(GetVipDetailRowData o1, GetVipDetailRowData o2) {
                return o1.hostName.compareTo(o2.hostName);
            }
        });
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            VipGetDetailsHandler.getGson().toJson((Object)details, GetVipDetailsData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

