/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.DeleteVipData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class VipDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public VipDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteVipData data = this.fromJson(request, DeleteVipData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "delete a vip");
        Vip vip = this.getVip(data.vipId, service);
        vip.setStatus(true, "Deleting...");
        this.getDataAccess().updateVip(vip);
        WorkItem workItem = new WorkItem(Type.vip, Operation.delete, user, team, service, null, null, vip, null);
        this.workItemProcessor.processWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

