/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.action.HostSmokeTestAction;
import com.northernwall.hadrian.workItem.dao.SmokeTestData;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class SmokeTestExecHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final OkHttpClient client;
    private final Parameters parameters;

    public SmokeTestExecHandler(AccessHelper accessHelper, DataAccess dataAccess, OkHttpClient client, Parameters parameters) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.client = client;
        this.parameters = parameters;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "execute smoke test");
        Module module = this.getModule(request, service);
        if (module.getSmokeTestUrl() == null || module.getSmokeTestUrl().isEmpty()) {
            throw new Http400BadRequestException("No smoke test url defined for module");
        }
        String endPoint = request.getParameter("endPoint");
        if (endPoint == null || endPoint.isEmpty()) {
            throw new Http400BadRequestException("No end point provided");
        }
        SmokeTestData smokeTestData = HostSmokeTestAction.ExecuteSmokeTest(module.getSmokeTestUrl(), endPoint, this.parameters, SmokeTestExecHandler.getGson(), this.client);
        if (smokeTestData == null) {
            throw new Http400BadRequestException("Error executing smoke test");
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            SmokeTestExecHandler.getGson().toJson((Object)smokeTestData, SmokeTestData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

