/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutModuleData;
import com.northernwall.hadrian.handlers.service.helper.FolderHelper;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http405NotAllowedException;
import com.northernwall.hadrian.schedule.ScheduleRunner;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleModifyHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleModifyHandler.class);
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;
    private final FolderHelper folderHelper;

    public static void checkEnvironmentNames(Map<String, Boolean> environmentNames) throws Http400BadRequestException {
        if (environmentNames == null || environmentNames.isEmpty()) {
            throw new Http400BadRequestException("At least one environment must be selected");
        }
        LinkedList<String> falseKeys = null;
        for (Map.Entry<String, Boolean> entry : environmentNames.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            if (falseKeys == null) {
                falseKeys = new LinkedList<String>();
            }
            falseKeys.add(entry.getKey());
        }
        if (falseKeys != null) {
            for (String key : falseKeys) {
                environmentNames.remove(key);
            }
        }
        if (environmentNames == null || environmentNames.isEmpty()) {
            throw new Http400BadRequestException("At least one environment must be selected");
        }
    }

    public ModuleModifyHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor, FolderHelper folderHelper) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
        this.folderHelper = folderHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutModuleData data = this.fromJson(request, PutModuleData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "update module");
        List<Host> hosts = this.getDataAccess().getHosts(data.serviceId);
        for (Host host : hosts) {
            Boolean temp;
            if (!host.getModuleId().equals(data.moduleId) || (temp = data.environmentNames.get(host.getEnvironment())) != null && temp.booleanValue()) continue;
            throw new Http400BadRequestException("Can not remove a environment from a module with an active host");
        }
        List<Vip> vips = this.getDataAccess().getVips(data.serviceId);
        for (Vip vip : vips) {
            Object temp;
            if (!vip.getModuleId().equals(data.moduleId) || (temp = data.environmentNames.get(vip.getEnvironment())) != null && ((Boolean)temp).booleanValue()) continue;
            throw new Http400BadRequestException("Can not remove a environment from a module with an active VIP");
        }
        List<Module> list = this.getDataAccess().getModules(data.serviceId);
        Module module = null;
        for (Module temp : list) {
            if (!temp.getModuleId().equals(data.moduleId)) continue;
            module = temp;
        }
        if (module == null) {
            LOGGER.warn("Could not find module with id {} in service {}", (Object)data.moduleId, (Object)data.serviceId);
            return;
        }
        switch (module.getModuleType()) {
            case Library: {
                data.outbound = "No";
                data.hostAbbr = "";
                data.versionUrl = "";
                data.availabilityUrl = "";
                data.smokeTestUrl = "";
                data.smokeTestCron = "";
                data.runAs = "";
                data.deploymentFolder = "";
                data.dataFolder = "";
                data.logsFolder = "";
                data.startCmdLine = "";
                data.startTimeOut = 0;
                data.stopCmdLine = "";
                data.stopTimeOut = 0;
                break;
            }
            case Simulator: {
                data.outbound = "No";
                data.smokeTestUrl = "";
                data.smokeTestCron = "";
            }
            case Deployable: {
                SearchResult searchResult;
                if (data.hostAbbr.contains("-")) {
                    throw new Http400BadRequestException("Can not have '-' in host abbr");
                }
                if (service.isDoDeploys()) {
                    data.deploymentFolder = this.folderHelper.scrubFolder(data.deploymentFolder, "Deployment", false);
                    data.logsFolder = this.folderHelper.scrubFolder(data.logsFolder, "Logs", false);
                    data.dataFolder = this.folderHelper.scrubFolder(data.dataFolder, "Data", true);
                    this.folderHelper.isWhiteListed(data.deploymentFolder, "Deployment", data.runAs);
                    this.folderHelper.isWhiteListed(data.logsFolder, "Logs", data.runAs);
                    this.folderHelper.isSubFolder(data.logsFolder, "Logs", data.deploymentFolder, "Deployment");
                    if (data.dataFolder != null && !data.dataFolder.isEmpty()) {
                        this.folderHelper.isWhiteListed(data.dataFolder, "Data", data.runAs);
                        this.folderHelper.isSubFolder(data.dataFolder, "Data", data.deploymentFolder, "Deployment");
                    }
                } else {
                    data.deploymentFolder = null;
                    data.logsFolder = null;
                    data.dataFolder = null;
                }
                if (!(service.getMavenGroupId() == null || service.getMavenGroupId().isEmpty() || data.mavenArtifactId == null || data.mavenArtifactId.isEmpty() || (searchResult = this.getDataAccess().doSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + data.mavenArtifactId)) == null || searchResult.moduleId.equals(data.moduleId))) {
                    throw new Http405NotAllowedException("A service and module already exists with this maven group and artifact");
                }
                try {
                    if (data.smokeTestCron != null && !data.smokeTestCron.isEmpty()) {
                        ScheduleRunner.parseCron(data.smokeTestCron);
                    }
                }
                catch (Exception e) {
                    throw new Http400BadRequestException("Illegal cron, " + e.getMessage());
                }
                ModuleModifyHandler.checkEnvironmentNames(data.environmentNames);
            }
        }
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && module.getMavenArtifactId() != null && !module.getMavenArtifactId().isEmpty()) {
            this.getDataAccess().deleteSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + module.getMavenArtifactId());
        }
        module.setModuleName(data.moduleName);
        module.setGitFolder(data.gitFolder);
        module.setMavenArtifactId(data.mavenArtifactId);
        module.setArtifactType(data.artifactType);
        module.setArtifactSuffix(data.artifactSuffix);
        module.setOutbound(data.outbound);
        module.setHostAbbr(data.hostAbbr.toLowerCase());
        module.setVersionUrl(data.versionUrl);
        module.setAvailabilityUrl(data.availabilityUrl);
        module.setSmokeTestUrl(data.smokeTestUrl);
        module.setSmokeTestCron(data.smokeTestCron);
        module.setRunAs(data.runAs);
        module.setDeploymentFolder(data.deploymentFolder);
        module.setDataFolder(data.dataFolder);
        module.setLogsFolder(data.logsFolder);
        module.setLogsRetention(data.logsRetention);
        module.setStartCmdLine(data.startCmdLine);
        module.setStartTimeOut(data.startTimeOut);
        module.setStopCmdLine(data.stopCmdLine);
        module.setStopTimeOut(data.stopTimeOut);
        module.setConfigName(data.configName);
        module.setEnvironmentNames(data.environmentNames);
        module.cleanEnvironmentNames(null);
        this.getDataAccess().saveModule(module);
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && module.getMavenArtifactId() != null && !module.getMavenArtifactId().isEmpty()) {
            this.getDataAccess().insertSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + module.getMavenArtifactId(), service.getServiceId(), module.getModuleId(), null);
        }
        WorkItem workItem = new WorkItem(Type.module, Operation.update, user, team, service, module, null, null, null);
        for (Module temp : list) {
            workItem.addModule(temp);
        }
        this.workItemProcessor.processWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

