/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ModuleFileDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ModuleFileDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        Module module = this.getModule(request, service);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "manage file for module");
        String environment = request.getParameter("environment");
        if (environment == null || environment.isEmpty()) {
            throw new Http400BadRequestException("parameter environment is missing");
        }
        String fileName = this.getFileName(request);
        this.getDataAccess().deleteModuleFile(service.getServiceId(), module.getModuleId(), environment, fileName);
        this.createAudit(service.getServiceId(), module.getModuleName(), user.getUsername(), "Delete file " + fileName + " on " + environment);
        response.setStatus(200);
        request.setHandled(true);
    }

    private void createAudit(String serviceId, String moduleName, String requestor, String action) {
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("action", action);
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.moduleName = moduleName;
        audit.setTimePerformed(GMT.getGmtAsDate());
        audit.timeRequested = GMT.getGmtAsDate();
        audit.requestor = requestor;
        audit.type = Type.module;
        audit.operation = Operation.update;
        audit.successfull = true;
        audit.notes = ModuleFileDeleteHandler.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

