/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.ModuleModifyHandler;
import com.northernwall.hadrian.handlers.service.dao.PostModuleData;
import com.northernwall.hadrian.handlers.service.helper.FolderHelper;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http405NotAllowedException;
import com.northernwall.hadrian.schedule.ScheduleRunner;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ModuleCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final WorkItemProcessor workItemProcessor;
    private final FolderHelper folderHelper;

    public ModuleCreateHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor, FolderHelper folderHelper) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.workItemProcessor = workItemProcessor;
        this.folderHelper = folderHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        SearchResult searchResult;
        PostModuleData data = this.fromJson(request, PostModuleData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a module");
        Config config = this.configHelper.getConfig();
        String template = null;
        switch (data.moduleType) {
            case Deployable: {
                if (!config.deployableTemplates.contains(data.deployableTemplate)) {
                    throw new Http400BadRequestException("Unknown deployable template");
                }
                template = data.deployableTemplate;
                break;
            }
            case Library: {
                if (!config.libraryTemplates.contains(data.libraryTemplate)) {
                    throw new Http400BadRequestException("Unknown library template");
                }
                template = data.libraryTemplate;
                break;
            }
            case Simulator: {
                if (!config.deployableTemplates.contains(data.deployableTemplate)) {
                    throw new Http400BadRequestException("Unknown Simulator template");
                }
                template = data.deployableTemplate;
            }
        }
        if (!config.artifactTypes.contains(data.artifactType)) {
            throw new Http400BadRequestException("Unknown artifact");
        }
        if (service.getServiceType().equals("Shared Library")) {
            data.moduleType = ModuleType.Library;
        }
        switch (data.moduleType) {
            case Library: {
                data.hostAbbr = "";
                data.versionUrl = "";
                data.availabilityUrl = "";
                data.runAs = "";
                data.deploymentFolder = "";
                data.dataFolder = "";
                data.logsFolder = "";
                data.startCmdLine = "";
                data.startTimeOut = 0;
                data.stopCmdLine = "";
                data.stopTimeOut = 0;
                break;
            }
            case Simulator: {
                data.outbound = "No";
                data.smokeTestUrl = "";
            }
            case Deployable: {
                if (data.hostAbbr.contains("-")) {
                    throw new Http400BadRequestException("Can not have '-' in host abbr");
                }
                if (service.isDoDeploys()) {
                    data.deploymentFolder = this.folderHelper.scrubFolder(data.deploymentFolder, "Deployment", false);
                    data.logsFolder = this.folderHelper.scrubFolder(data.logsFolder, "Logs", false);
                    data.dataFolder = this.folderHelper.scrubFolder(data.dataFolder, "Data", true);
                    this.folderHelper.isWhiteListed(data.deploymentFolder, "Deployment", data.runAs);
                    this.folderHelper.isWhiteListed(data.logsFolder, "Logs", data.runAs);
                    this.folderHelper.isSubFolder(data.logsFolder, "Logs", data.deploymentFolder, "Deployment");
                    if (data.dataFolder != null && !data.dataFolder.isEmpty()) {
                        this.folderHelper.isWhiteListed(data.dataFolder, "Data", data.runAs);
                        this.folderHelper.isSubFolder(data.dataFolder, "Data", data.deploymentFolder, "Deployment");
                    }
                } else {
                    data.deploymentFolder = null;
                    data.logsFolder = null;
                    data.dataFolder = null;
                }
                ModuleModifyHandler.checkEnvironmentNames(data.environmentNames);
            }
        }
        List<Module> modules = this.getDataAccess().getModules(data.serviceId);
        if (modules != null && !modules.isEmpty()) {
            for (Module temp : modules) {
                String tempGitFolder;
                if (temp.getGitFolder() == null || temp.getGitFolder().isEmpty()) {
                    throw new Http400BadRequestException("Can not create new module while module " + temp.getModuleName() + " is at the git folder root.");
                }
                if (data.moduleName.equalsIgnoreCase(temp.getModuleName())) {
                    throw new Http400BadRequestException("There already exists a module named " + data.moduleName);
                }
                String gitFolder = "/" + data.gitFolder.toUpperCase() + "/";
                if (gitFolder.equals(tempGitFolder = "/" + temp.getGitFolder().toUpperCase() + "/")) {
                    throw new Http400BadRequestException("Error there already exists a module in folder " + data.gitFolder);
                }
                if (gitFolder.startsWith(tempGitFolder)) {
                    throw new Http400BadRequestException("A Module's git folder may not be a sub folder of another module");
                }
                if (!tempGitFolder.startsWith(gitFolder)) continue;
                throw new Http400BadRequestException("A Module's git folder may not be a sub folder of another module");
            }
        }
        if (data.gitFolder == null) {
            data.gitFolder = "";
        }
        if (data.gitFolder.startsWith("/")) {
            data.gitFolder = data.gitFolder.substring(1);
        }
        if (data.gitFolder.endsWith(".")) {
            data.gitFolder = data.gitFolder.substring(0, data.gitFolder.length() - 1);
        }
        if (data.gitFolder.endsWith("/")) {
            data.gitFolder = data.gitFolder.substring(0, data.gitFolder.length() - 1);
        }
        if (data.gitFolder.isEmpty() && modules != null && !modules.isEmpty()) {
            throw new Http400BadRequestException("This module can not be at the git folder root, if there is another module");
        }
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && data.mavenArtifactId != null && !data.mavenArtifactId.isEmpty() && (searchResult = this.getDataAccess().doSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + data.mavenArtifactId)) != null) {
            throw new Http405NotAllowedException("A service and module already exists with this maven group and artifact");
        }
        try {
            if (data.smokeTestCron != null && !data.smokeTestCron.isEmpty()) {
                ScheduleRunner.parseCron(data.smokeTestCron);
            }
        }
        catch (Exception e) {
            throw new Http400BadRequestException("Illegal cron, " + e.getMessage());
        }
        Module module = new Module(data.moduleName, data.serviceId, data.moduleType, data.gitFolder, data.mavenArtifactId, data.artifactType, data.artifactSuffix, data.outbound, data.hostAbbr.toLowerCase(), data.versionUrl, data.availabilityUrl, data.smokeTestUrl, data.smokeTestCron, data.runAs, data.deploymentFolder, data.dataFolder, data.logsFolder, data.logsRetention, data.startCmdLine, data.startTimeOut, data.stopCmdLine, data.stopTimeOut, data.configName, data.environmentNames);
        module.cleanEnvironmentNames(null);
        this.getDataAccess().saveModule(module);
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && module.getMavenArtifactId() != null && !module.getMavenArtifactId().isEmpty()) {
            this.getDataAccess().insertSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + module.getMavenArtifactId(), service.getServiceId(), module.getModuleId(), null);
        }
        WorkItem workItem = new WorkItem(Type.module, Operation.create, user, team, service, module, null, null, null);
        workItem.getMainModule().template = template;
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.workItemProcessor.processWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

