/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutRestartHostData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostRestartHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public HostRestartHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutRestartHostData data = this.fromJson(request, PutRestartHostData.class);
        Service service = this.getService(data.serviceId, data.serviceName);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanRestart(request, service.getTeamId());
        if (!service.isDoDeploys()) {
            throw new Http400BadRequestException("Service is configurationed to not allow deployments");
        }
        Module module = this.getModule(data.moduleId, data.moduleName, service);
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        LinkedList<WorkItem> workItems = new LinkedList<WorkItem>();
        for (Host host : hosts) {
            WorkItem workItem;
            if (!host.getModuleId().equals(module.getModuleId()) || !host.getEnvironment().equals(data.environment) || !data.all && !data.hostNames.contains(host.getHostName()) || host.isBusy()) continue;
            if (workItems.isEmpty()) {
                this.getDataAccess().updateSatus(host.getHostId(), true, "Restarting...");
            } else {
                this.getDataAccess().updateSatus(host.getHostId(), true, "Restart Queued");
            }
            if (service.isDoManageVip()) {
                workItem = new WorkItem(Type.host, Operation.disableVips, user, team, service, module, host, null, null);
                workItems.add(workItem);
            }
            workItem = new WorkItem(Type.host, Operation.restart, user, team, service, module, host, null, data.reason);
            workItem.getHost().doOsUpgrade = data.doOsUpgrade;
            workItems.add(workItem);
            if (module.getSmokeTestUrl() != null && !module.getSmokeTestUrl().isEmpty()) {
                workItem = new WorkItem(Type.host, Operation.smokeTest, user, team, service, module, host, null, null);
                workItems.add(workItem);
            }
            if (!service.isDoManageVip()) continue;
            workItem = new WorkItem(Type.host, Operation.enableVips, user, team, service, module, host, null, null);
            workItems.add(workItem);
        }
        this.workItemProcessor.processWorkItems(workItems);
        int status = 200;
        if (data.wait) {
            status = this.workItemProcessor.waitForProcess(((WorkItem)workItems.get(workItems.size() - 1)).getId(), (module.getStartTimeOut() + module.getStopTimeOut()) * 100, workItems.size() * (module.getStartTimeOut() + module.getStopTimeOut()) * 1500, service.getServiceName() + " " + module.getModuleName());
        }
        response.setStatus(status);
        request.setHandled(true);
    }
}

