/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Environment;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostHostData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostCreateHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostCreateHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final WorkItemProcessor workItemProcessor;

    public HostCreateHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostHostData data = this.fromJson(request, PostHostData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "add a host");
        Config config = this.configHelper.getConfig();
        this.checkRange(data.count, 1, config.maxCount, "host count");
        this.checkRange(data.sizeCpu, config.minCpu, config.maxCpu, "CPU size");
        this.checkRange(data.sizeMemory, config.minMemory, config.maxMemory, "memory size");
        this.checkRange(data.sizeStorage, config.minStorage, config.maxStorage, "storage size");
        if (!config.dataCenters.contains(data.dataCenter)) {
            throw new Http400BadRequestException("Unknown data center");
        }
        if (!config.environmentNames.contains(data.environment)) {
            throw new Http400BadRequestException("Unknown environment");
        }
        if (!config.platforms.contains(data.platform)) {
            throw new Http400BadRequestException("Unknown operating platform");
        }
        Module module = this.getModule(data.moduleId, null, service);
        if (module.getModuleType() == ModuleType.Library) {
            throw new Http400BadRequestException("Module must be a deployable or simulator");
        }
        String prefix = this.buildPrefix(data.environment, config, data.dataCenter, module.getHostAbbr());
        int createdCount = 0;
        for (int num = 1; createdCount < data.count && num <= config.maxTotalCount; ++num) {
            String hostName = this.buildHostName(prefix, num);
            SearchResult searchResult = this.getDataAccess().doSearch("hostName", hostName);
            if (searchResult != null) continue;
            LOGGER.info("Building host {} - {}/{}", new Object[]{hostName, ++createdCount, data.count});
            this.doCreateHost(hostName, data, user, team, service, module);
        }
        if (createdCount == 0) {
            throw new Http400BadRequestException("Could not create any hosts, max host count per data center reached");
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void doCreateHost(String hostName, PostHostData data, User user, Team team, Service service, Module module) throws IOException {
        Host host = new Host(hostName, data.serviceId, data.moduleId, data.dataCenter, data.environment, data.platform);
        this.getDataAccess().saveHost(host);
        this.getDataAccess().insertSearch("hostName", hostName, data.serviceId, data.moduleId, host.getHostId());
        this.getDataAccess().updateSatus(host.getHostId(), true, "Creating...");
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(3);
        WorkItem workItemCreate = new WorkItem(Type.host, Operation.create, user, team, service, module, host, null, data.reason);
        workItemCreate.getHost().sizeCpu = data.sizeCpu;
        workItemCreate.getHost().sizeMemory = data.sizeMemory;
        workItemCreate.getHost().sizeStorage = data.sizeStorage;
        workItemCreate.getHost().version = data.version;
        workItemCreate.getHost().configVersion = data.configVersion;
        workItems.add(workItemCreate);
        if (service.isDoDeploys()) {
            WorkItem workItemDeploy = new WorkItem(Type.host, Operation.deploy, user, team, service, module, host, null, data.reason);
            workItemDeploy.getHost().version = data.version;
            workItemDeploy.getHost().configVersion = data.configVersion;
            workItems.add(workItemDeploy);
        }
        if (service.isDoManageVip()) {
            WorkItem workItemEnable = new WorkItem(Type.host, Operation.addVips, user, team, service, module, host, null, null);
            workItems.add(workItemEnable);
        }
        this.workItemProcessor.processWorkItems(workItems);
    }

    private void checkRange(int value, int min, int max, String text) throws Http400BadRequestException {
        if (value < min) {
            throw new Http400BadRequestException("Requested " + text + " is less than allowed");
        }
        if (value > max) {
            throw new Http400BadRequestException("Requested " + text + " is greater than allowed");
        }
    }

    private String buildPrefix(String environmentName, Config config, String dataCenter, String abbr) {
        for (Environment environment : config.environments) {
            if (!environment.name.equals(environmentName)) continue;
            String prefix = environment.pattern;
            prefix = prefix.replace("{dc}", dataCenter);
            prefix = prefix.replace("{abbr}", abbr);
            return prefix;
        }
        throw new Http400BadRequestException("Unknown environment");
    }

    private String buildHostName(String prefix, int num) {
        String numStr = Integer.toString(num);
        numStr = "000".substring(numStr.length()) + numStr;
        return prefix + numStr;
    }
}

