/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostBackfillHostData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostBackfillHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostBackfillHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;

    public static String scrubHostname(String hostname) {
        if (hostname == null) {
            return null;
        }
        String temp = hostname.trim();
        if (temp == null || temp.isEmpty()) {
            return null;
        }
        int index = temp.indexOf(46);
        if (index == -1) {
            return temp;
        }
        if (index == 0) {
            return null;
        }
        if ((temp = temp.substring(0, index).trim()) == null || temp.isEmpty()) {
            return null;
        }
        return temp;
    }

    public HostBackfillHandler(AccessHelper accessHelper, ConfigHelper configHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String[] hostnames;
        PostBackfillHostData data = this.fromJson(request, PostBackfillHostData.class);
        Service service = this.getService(data.serviceId, null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "backfill host");
        Config config = this.configHelper.getConfig();
        if (!config.dataCenters.contains(data.dataCenter)) {
            throw new Http400BadRequestException("unknown datacenter, " + data.dataCenter);
        }
        if (!config.environmentNames.contains(data.environment)) {
            throw new Http400BadRequestException("unknown environment, " + data.environment);
        }
        if (!config.platforms.contains(data.platform)) {
            throw new Http400BadRequestException("unknown operating platform, " + data.platform);
        }
        if (data.hosts == null || data.hosts.isEmpty()) {
            throw new Http400BadRequestException("Hosts is empty");
        }
        Module module = this.getModule(data.moduleId, null, service);
        if (module.getModuleType() != ModuleType.Deployable && module.getModuleType() != ModuleType.Simulator) {
            throw new Http400BadRequestException("Module must be a deployable or simulator");
        }
        int creationCount = 0;
        for (String hostname : hostnames = data.hosts.split(",")) {
            String scrubedHostName = HostBackfillHandler.scrubHostname(hostname);
            if (scrubedHostName == null || scrubedHostName.isEmpty()) continue;
            SearchResult searchResult = this.getDataAccess().doSearch("hostName", scrubedHostName);
            if (searchResult == null) {
                this.doBackfill(scrubedHostName, service, module, data, user);
                ++creationCount;
                continue;
            }
            LOGGER.warn("Could not backfill host {} ({}) becuase it already exists, {}", new Object[]{scrubedHostName, hostname, searchResult.hostId});
        }
        if (creationCount == 0) {
            throw new Http400BadRequestException("The listed hosts already exist");
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void doBackfill(String scrubedHostName, Service service, Module module, PostBackfillHostData data, User user) {
        Host host = new Host(scrubedHostName, service.getServiceId(), module.getModuleId(), data.dataCenter, data.environment, data.platform);
        this.getDataAccess().saveHost(host);
        this.getDataAccess().insertSearch("hostName", scrubedHostName, service.getServiceId(), module.getModuleId(), host.getHostId());
        this.getDataAccess().updateSatus(host.getHostId(), false, "-");
        Audit audit = new Audit();
        audit.serviceId = service.getServiceId();
        audit.setTimePerformed(GMT.getGmtAsDate());
        audit.timeRequested = GMT.getGmtAsDate();
        audit.requestor = user.getUsername();
        audit.type = Type.host;
        audit.operation = Operation.create;
        audit.successfull = true;
        audit.moduleName = module.getModuleName();
        audit.hostName = scrubedHostName;
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("Reason", "Backfilled host.");
        notes.put("DC", data.dataCenter);
        notes.put("Environment", data.environment);
        notes.put("Plaform", data.platform);
        audit.notes = HostBackfillHandler.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

