/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class DocumentGetHandler
extends BasicHandler
implements ParameterChangeListener {
    private final OkHttpClient client;
    private final Parameters parameters;
    private final Map<String, String> tokens;
    private final Type type;
    private final Gson gson;

    public DocumentGetHandler(DataAccess dataAccess, OkHttpClient client, Parameters parameters) {
        super(dataAccess);
        this.client = client;
        this.parameters = parameters;
        this.tokens = new HashMap<String, String>();
        this.type = new TypeToken<Map<String, String>>(){}.getType();
        this.gson = new Gson();
        this.setup();
        parameters.registerChangeListener(this);
    }

    @Override
    public void onChange(List<String> keys) {
        this.setup();
    }

    private void setup() {
        this.tokens.clear();
        String s = this.parameters.getString("document.tokens", null);
        if (s == null || s.isEmpty()) {
            return;
        }
        this.tokens.putAll((Map)this.gson.fromJson(s, this.type));
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        for (Document doc : service.getDocuments()) {
            if (!doc.getDocId().equals(request.getParameter("docId"))) continue;
            com.squareup.okhttp.Request docRequest = new Request.Builder().url(this.addToken(doc.getLink())).build();
            try {
                Response resp = this.client.newCall(docRequest).execute();
                if (resp.isSuccessful()) {
                    try (InputStream inputStream = resp.body().byteStream();){
                        byte[] buffer = new byte[51200];
                        int len = inputStream.read(buffer);
                        while (len != -1) {
                            response.getOutputStream().write(buffer, 0, len);
                            len = inputStream.read(buffer);
                        }
                        response.getOutputStream().flush();
                    }
                    response.setStatus(200);
                    request.setHandled(true);
                    return;
                }
                throw new Http400BadRequestException("Could not get document " + doc.getTitle() + " at " + doc.getLink() + " status " + resp.code());
            }
            catch (UnknownHostException ex) {
                throw new Http400BadRequestException("Error: Unknown host!");
            }
            catch (ConnectException | SocketTimeoutException ex) {
                throw new Http400BadRequestException("Error: Time out!");
            }
        }
        throw new Http400BadRequestException("Could not find document");
    }

    private String addToken(String url) {
        int end;
        int start = url.indexOf("/") + 2;
        String domain = url.substring(start, end = url.indexOf("/", start));
        String token = this.tokens.get(domain);
        if (token == null) {
            return url;
        }
        if (url.indexOf("?") > 0) {
            return url + "&" + token;
        }
        return url + "?" + token;
    }
}

