/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PostAuditData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class AuditCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public AuditCreateHandler(DataAccess dataAccess, AccessHelper accessHelper) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostAuditData data = this.fromJson(request, PostAuditData.class);
        Service service = this.getService(data.serviceId, data.serviceName);
        User user = this.accessHelper.checkIfUserCanAudit(request, service.getTeamId());
        Audit audit = new Audit();
        audit.serviceId = service.getServiceId();
        audit.setTimePerformed(GMT.getGmtAsDate());
        audit.timeRequested = GMT.getGmtAsDate();
        audit.requestor = user.getUsername();
        audit.type = data.type;
        audit.operation = data.operation;
        audit.successfull = true;
        if (data.hostName != null) {
            audit.hostName = data.hostName;
        }
        if (data.vipName != null) {
            audit.vipName = data.vipName;
        }
        audit.notes = data.notes;
        this.getDataAccess().saveAudit(audit, data.output);
        response.setStatus(200);
        request.setHandled(true);
    }
}

