/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.report;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.handlers.report.HostFullReport;
import com.northernwall.hadrian.handlers.report.HostSummaryReport;
import com.northernwall.hadrian.handlers.report.Report;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ReportHandler
extends AbstractHandler {
    private final AccessHelper accessHelper;
    private final DataAccess dataAccess;
    private final ConfigHelper configHelper;

    public ReportHandler(AccessHelper accessHelper, DataAccess dataAccess, ConfigHelper configHelper) {
        this.accessHelper = accessHelper;
        this.dataAccess = dataAccess;
        this.configHelper = configHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        this.accessHelper.checkIfUserIsAdmin(request, "Report");
        String type = request.getParameter("type");
        if (type != null && !type.isEmpty()) {
            type = type.toLowerCase();
            Report report = null;
            switch (type) {
                case "hostsummary": {
                    report = new HostSummaryReport(this.dataAccess, this.configHelper.getConfig(), response.getWriter());
                    break;
                }
                case "hostfull": {
                    report = new HostFullReport(this.dataAccess, response.getWriter());
                    break;
                }
                default: {
                    throw new Http400BadRequestException("Unknown report type");
                }
            }
            ((Report)report).runReport();
            response.getWriter().flush();
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

