/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.report;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;

public abstract class Report {
    protected final DataAccess dataAccess;
    protected final PrintWriter writer;

    public Report(DataAccess dataAccess, PrintWriter writer) {
        this.dataAccess = dataAccess;
        this.writer = writer;
    }

    public abstract void runReport() throws IOException;

    protected void outputServiceHeader() throws IOException {
        this.writer.print("Team,Service,Scope,DoBuilds,DoDeploys,DoManageVip,DoCheckJar");
    }

    protected void outputServiceRow(Team team, Service service) throws IOException {
        this.writer.print(team.getTeamName());
        this.writer.print(",");
        this.writer.print(service.getServiceName());
        this.writer.print(",");
        this.writer.print(service.getScope());
        this.writer.print(",");
        this.writer.print(service.isDoBuilds());
        this.writer.print(",");
        this.writer.print(service.isDoDeploys());
        this.writer.print(",");
        this.writer.print(service.isDoManageVip());
        this.writer.print(",");
        this.writer.print(service.isDoCheckJar());
    }

    protected void outputModuleHeader() throws IOException {
        this.writer.print(",Module,Type,HostAbbr,Outbound,RunAs");
    }

    protected void outputModuleRow(Module module) throws IOException {
        if (module == null) {
            this.writer.print(",,,,,");
            return;
        }
        this.writer.print(",");
        this.writer.print(module.getModuleName());
        this.writer.print(",");
        this.writer.print((Object)module.getModuleType());
        if (module.getModuleType() != ModuleType.Library) {
            this.writer.print(",");
            this.writer.print(module.getHostAbbr());
            this.writer.print(",");
            this.writer.print(module.getOutbound());
            this.writer.print(",");
            this.writer.print(module.getRunAs());
        } else {
            this.writer.print(",,,");
        }
    }

    protected void outputHostHeader() {
        this.writer.print(",HostName,DataCenter,Environmnt,Platform");
    }

    protected void outputHostRow(Host host) {
        if (host == null) {
            this.writer.print(",,,,");
            return;
        }
        this.writer.print(",");
        this.writer.print(host.getHostName());
        this.writer.print(",");
        this.writer.print(host.getDataCenter());
        this.writer.print(",");
        this.writer.print(host.getEnvironment());
        this.writer.print(",");
        this.writer.print(host.getPlatform());
    }

    protected void outputListHeader(List<String> headers) {
        for (String header : headers) {
            this.writer.print(",");
            this.writer.print(header);
        }
    }

    protected void outputListRows(List<String> headers, HashMap<String, Integer> counts, String defaultValue) {
        for (String header : headers) {
            this.writer.print(",");
            if (counts == null || counts.isEmpty()) continue;
            if (counts.containsKey(header)) {
                this.writer.print(counts.get(header));
                continue;
            }
            if (defaultValue == null || defaultValue.isEmpty()) continue;
            this.writer.print(defaultValue);
        }
    }
}

