/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.graph;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.graph.Graph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class GraphAllHandler
extends AbstractHandler {
    private final DataAccess dataAccess;

    public GraphAllHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/plain; charset=utf-8");
        Graph graph = new Graph((OutputStream)response.getOutputStream(), true);
        List<Service> services = this.dataAccess.getActiveServices();
        for (Service service : services) {
            Team team = this.dataAccess.getTeam(service.getTeamId());
            List<Module> modules = this.dataAccess.getModules(service.getServiceId());
            for (Module module : modules) {
                if (module.getModuleType() != ModuleType.Deployable) continue;
                LinkedList<Module> libraries = new LinkedList<Module>();
                this.processLibrary(module, module, libraries, graph);
                graph.writeModuleStructure(service, module, libraries, team.getColour());
            }
        }
        graph.close();
        request.setHandled(true);
        response.setStatus(200);
    }

    public void processLibrary(Module root, Module module, List<Module> libraries, Graph graph) throws IOException {
        List<ModuleRef> moduleRefs = this.dataAccess.getModuleRefsByClient(module.getServiceId(), module.getModuleId());
        for (ModuleRef moduleRef : moduleRefs) {
            Module serverModule = this.dataAccess.getModule(moduleRef.getServerServiceId(), moduleRef.getServerModuleId());
            if (serverModule.getModuleType() == ModuleType.Library && !libraries.contains(serverModule)) {
                libraries.add(serverModule);
                this.processLibrary(root, serverModule, libraries, graph);
            }
            if (serverModule.getModuleType() != ModuleType.Deployable) continue;
            graph.writeLink(root.getModuleName(), serverModule.getModuleName());
        }
    }
}

