/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.graph;

import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class Graph {
    private final BufferedWriter writer;

    public Graph(OutputStream outputStream, boolean isStruct) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        if (isStruct) {
            this.writer.append("digraph structs {");
            this.writer.newLine();
            this.writer.append("node[shape=record]");
        } else {
            this.writer.append("digraph {");
        }
        this.writer.newLine();
    }

    public void newLine() throws IOException {
        this.writer.newLine();
    }

    public void writeModule(Module module, String colour) throws IOException {
        this.writer.append(this.sanitize(module.getModuleName()));
        this.writer.append(" [shape=");
        if (module.getModuleType() == ModuleType.Deployable) {
            this.writer.append("rectangle");
        } else if (module.getModuleType() == ModuleType.Simulator) {
            this.writer.append("parallelogram");
        } else {
            this.writer.append("ellipse");
        }
        this.writer.append(" URL=\"#/Service/");
        this.writer.append(module.getServiceId());
        this.writer.append("\"");
        this.writer.append(" label=<");
        this.writer.append(module.getModuleName().trim());
        this.writer.append(">");
        this.writer.append(",color=\"");
        this.writer.append(colour);
        this.writer.append("\"];");
        this.writer.newLine();
    }

    public void writeModuleStructure(Service service, Module module, List<Module> libraries, String colour) throws IOException {
        this.writer.append(this.sanitize(module.getModuleName()));
        this.writer.append(" [label=\"");
        this.writer.append(service.getServiceName());
        this.writer.append("\\n");
        this.writer.append(module.getModuleName());
        if (libraries != null && !libraries.isEmpty()) {
            this.writer.append("|{");
            for (int c = 0; c < libraries.size(); ++c) {
                this.writer.append(libraries.get(c).getModuleName());
                if (c >= libraries.size() - 1) continue;
                this.writer.append("|");
            }
            this.writer.append("}");
        }
        this.writer.append("\",color=\"");
        this.writer.append(colour);
        this.writer.append("\"];");
        this.writer.newLine();
    }

    public void writeLink(String moduleA, String moduleB) throws IOException {
        this.writer.append(" ");
        this.writer.append(this.sanitize(moduleA));
        this.writer.append(" -> ");
        this.writer.append(this.sanitize(moduleB));
        this.writer.append(";");
        this.writer.newLine();
    }

    public void close() throws IOException {
        this.writer.append("}");
        this.writer.flush();
    }

    public String sanitize(String text) {
        return text.replace("-", "_").replace(".", "_").replace("=", "_").replace(" ", "_");
    }
}

