/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http404NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicHandler.class);
    private static final Gson gson = new Gson();
    private final DataAccess dataAccess;

    public BasicHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    public static Gson getGson() {
        return gson;
    }

    protected final <T> T fromJson(Request request, Class<T> classOfT) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
        Object temp = gson.fromJson((Reader)reader, classOfT);
        if (temp == null) {
            LOGGER.warn("Stream->Json returned null");
            throw new Http400BadRequestException("JSON payload is missing");
        }
        LOGGER.info("Stream->Json {}", (Object)gson.toJson(temp));
        return (T)temp;
    }

    protected Team getTeam(Request request) {
        return this.getTeam(request.getParameter("teamId"), request.getParameter("teamName"));
    }

    protected Team getTeam(String teamId, String teamName) {
        if (teamId != null && !teamId.isEmpty()) {
            Team team = this.dataAccess.getTeam(teamId);
            if (team != null) {
                return team;
            }
            throw new Http404NotFoundException("Could not find team with ID " + teamId);
        }
        if (teamName != null && !teamName.isEmpty()) {
            for (Team team : this.dataAccess.getTeams()) {
                if (!team.getTeamName().equalsIgnoreCase(teamName)) continue;
                return team;
            }
        }
        throw new Http404NotFoundException("Could not find team");
    }

    protected Service getService(Request request) {
        return this.getService(request.getParameter("serviceId"), request.getParameter("serviceName"));
    }

    protected Service getService(String serviceId, String serviceName) {
        if (serviceId != null && !serviceId.isEmpty()) {
            Service service = this.dataAccess.getService(serviceId);
            if (service != null) {
                return service;
            }
            throw new Http404NotFoundException("Could not find service with ID " + serviceId);
        }
        if (serviceName != null && !serviceName.isEmpty()) {
            for (Service service : this.dataAccess.getActiveServices()) {
                if (!service.getServiceName().equalsIgnoreCase(serviceName)) continue;
                return service;
            }
        }
        throw new Http404NotFoundException("Could not find service");
    }

    protected Module getModule(Request request, Service service) {
        return this.getModule(request.getParameter("moduleId"), request.getParameter("moduleName"), service);
    }

    protected Module getModule(String moduleId, String moduleName, Service service) {
        Module module;
        if (moduleId != null && !moduleId.isEmpty() && (module = this.dataAccess.getModule(service.getServiceId(), moduleId)) != null) {
            return module;
        }
        if (moduleName != null && !moduleName.isEmpty()) {
            for (Module module2 : this.dataAccess.getModules(service.getServiceId())) {
                if (!module2.getModuleName().equalsIgnoreCase(moduleName)) continue;
                return module2;
            }
        }
        throw new Http404NotFoundException("Could not find module");
    }

    protected String getFileName(Request request) {
        return request.getParameter("fileName");
    }

    protected Host getHost(Request request, Service service) {
        return this.getHost(request.getParameter("hostId"), request.getParameter("hostName"), service);
    }

    protected Host getHost(String hostId, String hostName, Service service) {
        Host host;
        if (hostId != null && !hostId.isEmpty() && (host = this.dataAccess.getHost(service.getServiceId(), hostId)) != null) {
            return host;
        }
        if (hostName != null && !hostName.isEmpty()) {
            for (Host host2 : this.dataAccess.getHosts(service.getServiceId())) {
                if (!host2.getHostName().equalsIgnoreCase(hostName)) continue;
                return host2;
            }
        }
        throw new Http404NotFoundException("Could not find host");
    }

    protected Vip getVip(Request request, Service service) {
        return this.getVip(request.getParameter("vipId"), service);
    }

    protected Vip getVip(String vipId, Service service) {
        Vip vip;
        if (vipId != null && !vipId.isEmpty() && (vip = this.dataAccess.getVip(service.getServiceId(), vipId)) != null) {
            return vip;
        }
        throw new Http404NotFoundException("Could not find vip");
    }

    protected void waitForFutures(List<Future> futures, int loopMax, int loopSleep) {
        if (futures == null || futures.isEmpty()) {
            return;
        }
        for (int i = 0; i < loopMax; ++i) {
            try {
                Thread.sleep(loopSleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            futures.removeIf(new Predicate<Future>(){

                @Override
                public boolean test(Future t) {
                    return t.isDone();
                }
            });
            if (!futures.isEmpty()) continue;
            return;
        }
    }
}

