/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.domain;

import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.FindBugsLevel;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class Service
implements Comparable<Service> {
    private String serviceId = UUID.randomUUID().toString();
    private String serviceName;
    private String teamId;
    private String description;
    private String serviceType;
    private String gitProject;
    private String scope;
    private String mavenGroupId;
    private boolean doBuilds;
    private boolean doDeploys;
    private boolean doManageVip;
    private boolean doCheckJar;
    private FindBugsLevel doFindBugsLevel;
    private String testStyle;
    private String testHostname;
    private String testRunAs;
    private String testDeploymentFolder;
    private String testCmdLine;
    private int testTimeOut;
    private List<Document> documents;
    private Date creationDate;
    private Date deletionDate;
    private boolean active = true;

    public static List<Service> filterTeam(String teamId, List<Service> services) {
        LinkedList<Service> temp = new LinkedList<Service>();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                if (!service.getTeamId().equals(teamId)) continue;
                temp.add(service);
            }
        }
        return temp;
    }

    public Service(String serviceName, String teamId, String description, String serviceType, String gitProject, String scope, String mavenGroupId, boolean doBuilds, boolean doDeploys, boolean doManageVip, boolean doCheckJar, FindBugsLevel doFindBugsLevel, String testStyle, String testHostname, String testRunAs, String testDeploymentFolder, String testCmdLine, int testTimeOut, boolean active) {
        this.serviceName = serviceName;
        this.teamId = teamId;
        this.description = description;
        this.serviceType = serviceType;
        this.gitProject = gitProject;
        this.scope = scope;
        this.mavenGroupId = mavenGroupId;
        this.doBuilds = doBuilds;
        this.doDeploys = doDeploys;
        this.doManageVip = doManageVip;
        this.doCheckJar = doCheckJar;
        this.doFindBugsLevel = doFindBugsLevel;
        this.testStyle = testStyle;
        this.testHostname = testHostname;
        this.testRunAs = testRunAs;
        this.testDeploymentFolder = testDeploymentFolder;
        this.testCmdLine = testCmdLine;
        this.testTimeOut = testTimeOut;
        this.documents = new LinkedList<Document>();
        this.creationDate = GMT.getGmtAsDate();
        this.deletionDate = null;
        this.active = active;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getGitProject() {
        return this.gitProject;
    }

    public void setGitProject(String gitProject) {
        this.gitProject = gitProject;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getMavenGroupId() {
        return this.mavenGroupId;
    }

    public void setMavenGroupId(String mavenGroupId) {
        this.mavenGroupId = mavenGroupId;
    }

    public boolean isDoBuilds() {
        return this.doBuilds;
    }

    public void setDoBuilds(boolean doBuilds) {
        this.doBuilds = doBuilds;
    }

    public boolean isDoDeploys() {
        return this.doDeploys;
    }

    public void setDoDeploys(boolean doDeploys) {
        this.doDeploys = doDeploys;
    }

    public boolean isDoCheckJar() {
        return this.doCheckJar;
    }

    public boolean isDoManageVip() {
        return this.doManageVip;
    }

    public void setDoManageVip(boolean doManageVip) {
        this.doManageVip = doManageVip;
    }

    public void setDoCheckJar(boolean doCheckJar) {
        this.doCheckJar = doCheckJar;
    }

    public FindBugsLevel getDoFindBugsLevel() {
        if (this.doFindBugsLevel == null) {
            return FindBugsLevel.report;
        }
        return this.doFindBugsLevel;
    }

    public void setDoFindBugsLevel(FindBugsLevel doFindBugsLevel) {
        this.doFindBugsLevel = doFindBugsLevel;
    }

    public String getTestStyle() {
        return this.testStyle;
    }

    public void setTestStyle(String testStyle) {
        this.testStyle = testStyle;
    }

    public String getTestHostname() {
        return this.testHostname;
    }

    public void setTestHostname(String testHostname) {
        this.testHostname = testHostname;
    }

    public String getTestRunAs() {
        return this.testRunAs;
    }

    public void setTestRunAs(String testRunAs) {
        this.testRunAs = testRunAs;
    }

    public String getTestDeploymentFolder() {
        return this.testDeploymentFolder;
    }

    public void setTestDeploymentFolder(String testDeploymentFolder) {
        this.testDeploymentFolder = testDeploymentFolder;
    }

    public String getTestCmdLine() {
        return this.testCmdLine;
    }

    public void setTestCmdLine(String testCmdLine) {
        this.testCmdLine = testCmdLine;
    }

    public int getTestTimeOut() {
        if (this.testTimeOut == 0) {
            return 300;
        }
        return this.testTimeOut;
    }

    public void setTestTimeOut(int testTimeOut) {
        this.testTimeOut = testTimeOut;
    }

    public List<Document> getDocuments() {
        if (this.documents == null) {
            this.documents = new LinkedList<Document>();
        }
        return this.documents;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getDeletionDate() {
        return this.deletionDate;
    }

    public void setDeletionDate(Date deletionDate) {
        this.deletionDate = deletionDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int compareTo(Service o) {
        return this.serviceName.compareToIgnoreCase(o.serviceName);
    }
}

