/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.details.simple;

import com.google.gson.Gson;
import com.northernwall.hadrian.details.simple.dao.VipDao;
import com.northernwall.hadrian.details.simple.dao.VipMemberDao;
import com.northernwall.hadrian.details.simple.dao.VipPoolDao;
import com.northernwall.hadrian.details.simple.dao.VipPoolsDao;
import com.northernwall.hadrian.details.simple.dao.VipPortDao;
import com.northernwall.hadrian.details.simple.dao.VipsDao;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.service.dao.GetVipDetailCellData;
import com.northernwall.hadrian.handlers.service.dao.GetVipDetailsData;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVipDetailsRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleVipDetailsRunnable.class);
    private final Gson gson;
    private final OkHttpClient client;
    private final Vip vip;
    private final GetVipDetailsData data;
    private final String vipUrl;
    private final String poolUrl;
    private final String dataCenter;

    public SimpleVipDetailsRunnable(Gson gson, OkHttpClient client, Vip vip, GetVipDetailsData data, String vipUrl, String poolUrl, String dataCenter) {
        this.gson = gson;
        this.client = client;
        this.vip = vip;
        this.data = data;
        this.vipUrl = vipUrl;
        this.poolUrl = poolUrl;
        this.dataCenter = dataCenter;
    }

    @Override
    public void run() {
        VipDao vipInfo = this.getVipInfo(this.vipUrl, this.dataCenter);
        if (vipInfo == null) {
            return;
        }
        this.data.address.put(this.dataCenter, vipInfo.address);
        this.data.name.put(this.dataCenter, vipInfo.name);
        for (VipPortDao vipPortInfo : vipInfo.ports) {
            if (vipPortInfo.port != this.vip.getVipPort()) continue;
            VipPoolDao vipPoolInfo = this.getPoolInfo(this.poolUrl, vipPortInfo.poolName, this.dataCenter);
            if (vipPoolInfo != null) {
                this.data.connections.put(this.dataCenter, Integer.toString(vipPoolInfo.connections));
                for (VipMemberDao member : vipPoolInfo.members) {
                    GetVipDetailCellData cell = new GetVipDetailCellData();
                    cell.priority = member.priority;
                    cell.connections = member.connections;
                    cell.status = member.status == 0 ? "Off" : (member.status == 1 ? "On" : "Error");
                    this.data.find((String)member.hostName).details.put(this.dataCenter, cell);
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VipDao getVipInfo(String url, String dataCenter) {
        url = url.replace("{dc}", dataCenter.toUpperCase());
        Request httpRequest = new Request.Builder().url(url).build();
        try {
            Response resp = this.client.newCall(httpRequest).execute();
            try (InputStream stream = resp.body().byteStream();){
                if (resp.isSuccessful()) {
                    InputStreamReader reader = new InputStreamReader(stream);
                    VipsDao vipsInfo = (VipsDao)this.gson.fromJson((Reader)reader, VipsDao.class);
                    VipDao vipDao = vipsInfo.vips.get(0);
                    return vipDao;
                }
                LOGGER.warn("Call to {} failed with code {}", (Object)url, (Object)resp.code());
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error while getting secondary vip details with {}, error {}", (Object)url, (Object)ex.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VipPoolDao getPoolInfo(String url, String poolName, String dataCenter) {
        url = url.replace("{pool}", poolName);
        url = url.replace("{dc}", dataCenter.toUpperCase());
        Request httpRequest = new Request.Builder().url(url).build();
        try {
            Response resp = this.client.newCall(httpRequest).execute();
            try (InputStream stream = resp.body().byteStream();){
                if (resp.isSuccessful()) {
                    InputStreamReader reader = new InputStreamReader(stream);
                    VipPoolsDao vipPoolsInfo = (VipPoolsDao)this.gson.fromJson((Reader)reader, VipPoolsDao.class);
                    VipPoolDao vipPoolDao = vipPoolsInfo.pools.get(0);
                    return vipPoolDao;
                }
                LOGGER.warn("Call to {} failed with code {}", (Object)url, (Object)resp.code());
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error while getting secondary vip details with {}, error {}", (Object)url, (Object)ex.getMessage());
        }
        return null;
    }
}

