/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.details;

import com.google.gson.Gson;
import com.northernwall.hadrian.Const;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.details.ServiceBuildData;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBuildHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBuildHelper.class);
    private final DataAccess dataAccess;
    private final OkHttpClient client;
    private final Parameters parameters;
    private final Gson gson;

    public ServiceBuildHelper(DataAccess dataAccess, OkHttpClient client, Parameters parameters) {
        this.dataAccess = dataAccess;
        this.client = client;
        this.parameters = parameters;
        this.gson = new Gson();
    }

    public void triggerBuild(Team team, Service service, String branch, User user) {
        if (team == null || service == null || branch == null || branch.isEmpty()) {
            return;
        }
        String url = this.parameters.getString("serviceBuild.url", null);
        if (url == null || url.isEmpty()) {
            return;
        }
        String username = this.parameters.getString("serviceBuild.username", null);
        String password = this.parameters.getString("serviceBuild.password", null);
        ServiceBuildData serviceBuildData = new ServiceBuildData();
        serviceBuildData.group = team.getGitGroup();
        serviceBuildData.project = service.getGitProject();
        serviceBuildData.branch = branch;
        Request.Builder builder = new Request.Builder().url(url);
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            builder = builder.addHeader("Authorization", Credentials.basic((String)username, (String)password));
        }
        RequestBody body = RequestBody.create((MediaType)Const.JSON_MEDIA_TYPE, (String)this.gson.toJson((Object)serviceBuildData));
        Request httpRequest = builder.post(body).build();
        try {
            Response resp = this.client.newCall(httpRequest).execute();
            if (resp.isSuccessful()) {
                LOGGER.warn("Build triggered to {} with code {}", (Object)url, (Object)resp.code());
                HashMap<String, String> notes = new HashMap<String, String>();
                notes.put("Reason", "Manually requested build");
                notes.put("Source Branch", branch);
                Audit audit = new Audit();
                audit.serviceId = service.getServiceId();
                audit.setTimePerformed(GMT.getGmtAsDate());
                audit.timeRequested = GMT.getGmtAsDate();
                audit.requestor = user.getUsername();
                audit.type = Type.service;
                audit.operation = Operation.build;
                audit.successfull = true;
                audit.notes = this.gson.toJson(notes);
                this.dataAccess.saveAudit(audit, null);
            } else {
                LOGGER.warn("Build not triggered {}, code {}", (Object)url, (Object)resp.code());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Error while triggering build {}, error {}", (Object)url, (Object)ex.getMessage());
        }
    }
}

