/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.inMemory;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.db.inMemory.ModuleRefPredicate;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleFile;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.utility.HealthWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryDataAccess
implements DataAccess {
    private String version = null;
    private final Map<String, Team> teams = new ConcurrentHashMap<String, Team>();
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private final Map<String, Host> hosts = new ConcurrentHashMap<String, Host>();
    private final Map<String, Vip> vips = new ConcurrentHashMap<String, Vip>();
    private final List<ModuleRef> moduleRefs = new LinkedList<ModuleRef>();
    private final Map<String, CustomFunction> customFunctions = new ConcurrentHashMap<String, CustomFunction>();
    private final Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private final Map<String, DataStore> dataStores = new ConcurrentHashMap<String, DataStore>();
    private final Map<String, WorkItem> workItems = new ConcurrentHashMap<String, WorkItem>();
    private final Map<String, User> users = new ConcurrentHashMap<String, User>();
    private final List<Audit> audits = new LinkedList<Audit>();
    private final Map<String, ModuleFile> moduleFiles = new ConcurrentHashMap<String, ModuleFile>();

    @Override
    public boolean getAvailability() {
        return true;
    }

    @Override
    public void getHealth(HealthWriter writer) {
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public List<Team> getTeams() {
        LinkedList<Team> temp = new LinkedList<Team>(this.teams.values());
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Team getTeam(String teamId) {
        return this.teams.get(teamId);
    }

    @Override
    public void saveTeam(Team team) {
        this.teams.put(team.getTeamId(), team);
    }

    @Override
    public void updateTeam(Team team) {
        this.teams.put(team.getTeamId(), team);
    }

    @Override
    public List<Service> getAllServices() {
        LinkedList<Service> temp = new LinkedList<Service>();
        for (Service service : this.services.values()) {
            temp.add(service);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public List<Service> getActiveServices() {
        LinkedList<Service> temp = new LinkedList<Service>();
        for (Service service : this.services.values()) {
            if (!service.isActive()) continue;
            temp.add(service);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Service getService(String serviceId) {
        return this.services.get(serviceId);
    }

    @Override
    public void saveService(Service service) {
        this.services.put(service.getServiceId(), service);
    }

    @Override
    public void updateService(Service service) {
        this.services.put(service.getServiceId(), service);
    }

    @Override
    public List<Host> getHosts(String serviceId) {
        LinkedList<Host> temp = new LinkedList<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.getServiceId().equals(serviceId)) continue;
            temp.add(host);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Host getHost(String serviceId, String hostId) {
        return this.hosts.get(hostId);
    }

    @Override
    public void saveHost(Host host) {
        this.hosts.put(host.getHostId(), host);
    }

    @Override
    public void updateHost(Host host) {
        this.hosts.put(host.getHostId(), host);
    }

    @Override
    public void deleteHost(Host host) {
        this.hosts.remove(host.getHostId());
    }

    @Override
    public List<Vip> getVips(String serviceId) {
        LinkedList<Vip> temp = new LinkedList<Vip>();
        for (Vip vip : this.vips.values()) {
            if (!vip.getServiceId().equals(serviceId)) continue;
            temp.add(vip);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Vip getVip(String serviceId, String vipId) {
        return this.vips.get(vipId);
    }

    @Override
    public void saveVip(Vip vip) {
        this.vips.put(vip.getVipId(), vip);
    }

    @Override
    public void updateVip(Vip vip) {
        this.vips.put(vip.getVipId(), vip);
    }

    @Override
    public void deleteVip(String serviceId, String vipId) {
        this.vips.remove(vipId);
    }

    @Override
    public List<ModuleRef> getModuleRefs() {
        return this.moduleRefs;
    }

    @Override
    public List<ModuleRef> getModuleRefsByClient(String clientServiceId, String clientModuleId) {
        LinkedList<ModuleRef> temp = new LinkedList<ModuleRef>();
        for (ModuleRef moduleRef : this.moduleRefs) {
            if (!moduleRef.getClientServiceId().equals(clientServiceId) || !moduleRef.getClientModuleId().equals(clientModuleId)) continue;
            temp.add(moduleRef);
        }
        return temp;
    }

    @Override
    public List<ModuleRef> getModuleRefsByServer(String serverServiceId, String serverModuleId) {
        LinkedList<ModuleRef> temp = new LinkedList<ModuleRef>();
        for (ModuleRef moduleRef : this.moduleRefs) {
            if (!moduleRef.getServerServiceId().equals(serverServiceId) || !moduleRef.getServerModuleId().equals(serverModuleId)) continue;
            temp.add(moduleRef);
        }
        return temp;
    }

    @Override
    public void saveModuleRef(ModuleRef moduleRef) {
        this.moduleRefs.add(moduleRef);
    }

    @Override
    public void deleteModuleRef(String clientServiceId, String clientModuleId, String serverServiceId, String serverModuleId) {
        this.moduleRefs.removeIf(new ModuleRefPredicate(clientServiceId, clientModuleId, serverServiceId, serverModuleId));
    }

    @Override
    public List<CustomFunction> getCustomFunctions(String serviceId) {
        LinkedList<CustomFunction> temp = new LinkedList<CustomFunction>();
        for (CustomFunction customFunction : this.customFunctions.values()) {
            if (!customFunction.getServiceId().equals(serviceId)) continue;
            temp.add(customFunction);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public CustomFunction getCustomFunction(String serviceId, String customFunctionId) {
        return this.customFunctions.get(customFunctionId);
    }

    @Override
    public void saveCustomFunction(CustomFunction customFunction) {
        this.customFunctions.put(customFunction.getCustomFunctionId(), customFunction);
    }

    @Override
    public void updateCustomFunction(CustomFunction customFunction) {
        this.customFunctions.put(customFunction.getCustomFunctionId(), customFunction);
    }

    @Override
    public void deleteCustomFunction(String serviceId, String customFunctionId) {
        this.customFunctions.remove(customFunctionId);
    }

    @Override
    public List<Module> getModules(String serviceId) {
        LinkedList<Module> temp = new LinkedList<Module>();
        for (Module module : this.modules.values()) {
            if (!module.getServiceId().equals(serviceId)) continue;
            temp.add(module);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Module getModule(String serviceId, String moduleId) {
        return this.modules.get(moduleId);
    }

    @Override
    public void saveModule(Module module) {
        this.modules.put(module.getModuleId(), module);
    }

    @Override
    public void updateModule(Module module) {
        this.modules.put(module.getModuleId(), module);
    }

    @Override
    public void deleteModule(String serviceId, String moduleId) {
        this.modules.remove(moduleId);
    }

    @Override
    public List<ModuleFile> getModuleFiles(String serviceId, String moduleId, String environment) {
        ArrayList<ModuleFile> moduleFileList = new ArrayList<ModuleFile>();
        for (ModuleFile moduleFile : this.moduleFiles.values()) {
            if (!moduleFile.getServiceId().equals(serviceId) || !moduleFile.getModuleId().equals(moduleId) || !moduleFile.getEnvironment().equals(environment)) continue;
            moduleFileList.add(moduleFile);
        }
        return moduleFileList;
    }

    @Override
    public ModuleFile getModuleFile(String serviceId, String moduleId, String environment, String name) {
        for (ModuleFile moduleFile : this.moduleFiles.values()) {
            if (!moduleFile.getServiceId().equals(serviceId) || !moduleFile.getModuleId().equals(moduleId) || !moduleFile.getEnvironment().equals(environment) || !moduleFile.getName().equals(name)) continue;
            return moduleFile;
        }
        return null;
    }

    @Override
    public void saveModuleFile(ModuleFile moduleFile) {
        this.moduleFiles.put(String.valueOf(moduleFile.hashCode()), moduleFile);
    }

    @Override
    public void updateModuleFile(ModuleFile moduleFile) {
    }

    @Override
    public void deleteModuleFile(String serviceId, String moduleId, String environment, String name) {
        Iterator<Map.Entry<String, ModuleFile>> it = this.moduleFiles.entrySet().iterator();
        while (it.hasNext()) {
            ModuleFile moduleFile = it.next().getValue();
            if (!moduleFile.getServiceId().equals(serviceId) || !moduleFile.getModuleId().equals(moduleId) || !moduleFile.getEnvironment().equals(environment) || !moduleFile.getName().equals(name)) continue;
            it.remove();
        }
    }

    @Override
    public List<DataStore> getDataStores(String serviceId) {
        LinkedList<DataStore> temp = new LinkedList<DataStore>();
        for (DataStore dataStore : this.dataStores.values()) {
            if (!dataStore.getServiceId().equals(serviceId)) continue;
            temp.add(dataStore);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public DataStore getDataStore(String serviceId, String dataStoreId) {
        return this.dataStores.get(dataStoreId);
    }

    @Override
    public void saveDataStore(DataStore dataStore) {
        this.dataStores.put(dataStore.getDataStoreId(), dataStore);
    }

    @Override
    public void updateDataStore(DataStore dataStore) {
        this.dataStores.put(dataStore.getDataStoreId(), dataStore);
    }

    @Override
    public void deleteDataStore(String serviceId, String dataStoreId) {
        this.dataStores.remove(dataStoreId);
    }

    @Override
    public List<WorkItem> getWorkItems() {
        LinkedList<WorkItem> temp = new LinkedList<WorkItem>(this.workItems.values());
        return temp;
    }

    @Override
    public WorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    @Override
    public void saveWorkItem(WorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
    }

    @Override
    public void deleteWorkItem(String id) {
        this.workItems.remove(id);
    }

    @Override
    public int getWorkItemStatus(String id) {
        return 200;
    }

    @Override
    public void saveWorkItemStatus(String id, int status) {
    }

    @Override
    public List<User> getUsers() {
        LinkedList<User> temp = new LinkedList<User>(this.users.values());
        Collections.sort(temp);
        return temp;
    }

    @Override
    public User getUser(String userName) {
        return this.users.get(userName);
    }

    @Override
    public void saveUser(User user) {
        this.users.put(user.getUsername(), user);
    }

    @Override
    public void updateUser(User user) {
        this.users.put(user.getUsername(), user);
    }

    @Override
    public void deleteUser(String userName) {
        this.users.remove(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAudit(Audit audit, String output) {
        audit.auditId = UUID.randomUUID().toString();
        List<Audit> list = this.audits;
        synchronized (list) {
            this.audits.add(audit);
            if (this.audits.size() > 1000) {
                this.audits.remove(0);
            }
        }
    }

    @Override
    public List<Audit> getAudit(String serviceId, int year, int month, int startDay, int endDay) {
        LinkedList<Audit> temp = new LinkedList<Audit>();
        for (Audit audit : this.audits) {
            if (!audit.serviceId.equals(serviceId)) continue;
            if (audit.auditId == null) {
                audit.auditId = UUID.randomUUID().toString();
            }
            temp.add(audit);
        }
        return temp;
    }

    @Override
    public String getAuditOutput(String serviceId, String auditId) {
        return null;
    }

    @Override
    public SearchResult doSearch(String searchSpace, String searchText) {
        return null;
    }

    @Override
    public void insertSearch(String searchSpace, String searchText, String serviceId, String moduleId, String hostId) {
    }

    @Override
    public void deleteSearch(String searchSpace, String searchText) {
    }

    @Override
    public void updateSatus(String id, boolean busy, String status) {
    }
}

