/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.access.simple;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.access.simple.SimpleSessionStore;
import com.northernwall.hadrian.domain.User;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAccessHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleAccessHandler.class);
    private final SimpleSessionStore sessionStore;

    public SimpleAccessHandler(AccessHelper accessHelper) {
        this.sessionStore = new SimpleSessionStore(accessHelper);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        if (request.getMethod().equals("POST") && target.equals("/login")) {
            if (this.checkAndStartSession(request, response)) {
                this.redirect("/ui/", response);
                request.setHandled(true);
                return;
            }
            LOGGER.warn("login failed!");
        } else {
            Cookie[] cookies = request.getCookies();
            if (cookies != null && cookies.length > 0) {
                for (Cookie cookie : request.getCookies()) {
                    User user;
                    if (!cookie.getName().equals("session") || (user = this.sessionStore.getUserForSession(cookie.getValue())) == null) continue;
                    request.setAttribute("session", (Object)cookie.getValue());
                    request.setAttribute("user", (Object)user);
                    request.setHandled(false);
                    return;
                }
            }
        }
        LOGGER.info("No session found, redirecting to login");
        this.redirect("/ui/login.html", response);
        response.addHeader("X-Login-Request", "true");
        request.setHandled(true);
    }

    private void redirect(String url, HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=utf-8");
        response.getOutputStream().print("<html><head><meta http-equiv=\"refresh\" content=\"1;url=" + url + "\"></head><body></body></html>");
    }

    private boolean checkAndStartSession(Request request, HttpServletResponse response) {
        Object credentials;
        String username = null;
        String password = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring("Basic".length()).trim();
            credentials = new String(Base64.getDecoder().decode(base64Credentials), Charset.forName("UTF-8"));
            String[] values = ((String)credentials).split(":", 2);
            username = values[0];
            password = values[1];
        } else {
            MultiMap mm = new MultiMap();
            request.extractFormParameters(mm);
            credentials = mm.keySet().iterator();
            while (credentials.hasNext()) {
                String key;
                switch (key = (String)credentials.next()) {
                    case "username": {
                        username = (String)mm.getValue(key, 0);
                        break;
                    }
                    case "password": {
                        password = (String)mm.getValue(key, 0);
                    }
                }
            }
        }
        if (!this.checkCreds(username, password)) {
            return false;
        }
        String sessionId = this.sessionStore.createUserSession(username);
        Cookie cookie = new Cookie("session", sessionId);
        cookie.setMaxAge(86400000);
        response.addCookie(cookie);
        return true;
    }

    protected boolean checkCreds(String username, String password) {
        return username != null && !username.isEmpty();
    }
}

