/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics.listeners;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dsh.metrics.Event;
import org.dsh.metrics.EventListener;

public class ConsoleListener
implements EventListener,
Runnable {
    private final BlockingQueue<Event> queue = new ArrayBlockingQueue<Event>(1000);
    private final int batchSize;
    private final long offerTime;
    private Thread runThread;
    private final PrintStream outStream;

    public ConsoleListener(PrintStream outStream) {
        this(outStream, 100);
    }

    public ConsoleListener(PrintStream out, int batchSize) {
        this(out, batchSize, -1L);
    }

    public ConsoleListener(PrintStream out, int batchSize, long offerTimeMillis) {
        this.batchSize = batchSize > 1 ? batchSize : 100;
        this.outStream = out;
        this.offerTime = offerTimeMillis;
        this.runThread = new Thread(this);
        this.runThread.setDaemon(true);
        this.runThread.start();
    }

    @Override
    public void run() {
        try {
            ArrayList<Event> dispatchList = new ArrayList<Event>(1000);
            while (true) {
                dispatchList.add(this.queue.take());
                this.queue.drainTo(dispatchList, this.batchSize - 1);
                dispatchList.stream().forEach(event -> this.outStream.println(event));
                dispatchList.clear();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public void onEvent(Event e) {
        if (this.offerTime > 0L) {
            try {
                this.queue.offer(e, this.offerTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.queue.offer(e);
        }
    }

    @Override
    public int eventsBuffered() {
        return this.queue.size();
    }
}

