/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import org.dsh.metrics.MetricBase;
import org.dsh.metrics.MetricKey;
import org.dsh.metrics.MetricRegistry;

public class Counter
extends MetricBase {
    private final LongAdder adder = new LongAdder();

    public Counter(String name, MetricRegistry registry) {
        super(name, registry, null);
    }

    public Counter(String name, MetricRegistry registry, Map<String, String> tags) {
        super(name, registry, tags);
    }

    public void increment() {
        this.adder.increment();
        this.registry.postEvent(this.name, System.currentTimeMillis(), this.adder.longValue());
    }

    public void decrement() {
        this.adder.decrement();
        this.registry.postEvent(this.name, System.currentTimeMillis(), this.adder.longValue());
    }

    public void add(long x) {
        this.adder.add(x);
        this.registry.postEvent(this.name, System.currentTimeMillis(), this.adder.longValue());
    }

    public static class Builder {
        private Map<String, String> tags = new HashMap<String, String>();
        private final MetricRegistry registry;
        private final String name;

        public Builder(String name, MetricRegistry registry) {
            this.registry = registry;
            this.name = name;
        }

        public Builder addTag(String tag, String value) {
            this.tags.put(tag, value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Counter build() {
            MetricKey k = new MetricKey(this.name, this.tags);
            Counter counter = this.registry.getCounters().get(k);
            if (counter == null) {
                MetricRegistry metricRegistry = this.registry;
                synchronized (metricRegistry) {
                    counter = this.registry.getCounters().get(k);
                    if (counter == null) {
                        counter = new Counter(this.name, this.registry, this.tags);
                    }
                }
            }
            return counter;
        }
    }
}

