/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VipDeleteAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(VipDeleteAction.class);

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Deleting Vip {} for {}", (Object)workItem.getVip().dns, (Object)workItem.getService().serviceName);
        Result result = Result.success;
        this.success(workItem);
        this.recordAudit(workItem, result, null);
        return result;
    }

    @Override
    public Result processCallback(WorkItem workItem, CallbackData callbackData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void recordAudit(WorkItem workItem, Result result, String output) {
        this.recordAudit(workItem, result, null, output);
    }

    protected void success(WorkItem workItem) {
        this.dataAccess.deleteVip(workItem.getService().serviceId, workItem.getVip().vipId);
    }

    protected void error(WorkItem workItem) {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            LOGGER.warn("Could not find vip {} being deleted", (Object)workItem.getVip().vipId);
            return;
        }
        vip.setStatus(false, "Delete failed");
        this.dataAccess.updateVip(vip);
    }
}

