/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VipCreateAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(VipCreateAction.class);

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Creating vip {} for {}", (Object)workItem.getVip().dns, (Object)workItem.getService().serviceName);
        Result result = Result.success;
        this.success(workItem);
        this.recordAudit(workItem, result, null);
        return result;
    }

    @Override
    public Result processCallback(WorkItem workItem, CallbackData callbackData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void recordAudit(WorkItem workItem, Result result, String output) {
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("Protocol", workItem.getVip().protocol);
        notes.put("DNS", workItem.getVip().dns + "." + workItem.getVip().domain);
        notes.put("VIP_Port", Integer.toString(workItem.getVip().vipPort));
        notes.put("Service_Port", Integer.toString(workItem.getVip().servicePort));
        notes.put("External", Boolean.toString(workItem.getVip().external));
        this.recordAudit(workItem, result, notes, output);
    }

    protected void success(WorkItem workItem) {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            LOGGER.warn("Could not find vip {} being created", (Object)workItem.getVip().vipId);
            return;
        }
        vip.setStatus(false, "-");
        this.dataAccess.updateVip(vip);
    }

    protected void error(WorkItem workItem) {
        Vip vip = this.dataAccess.getVip(workItem.getService().serviceId, workItem.getVip().vipId);
        if (vip == null) {
            LOGGER.warn("Could not find vip {} being created", (Object)workItem.getVip().vipId);
            return;
        }
        LOGGER.warn("Deleting host record due to failure in creating host {]", (Object)vip.getVipId());
        this.dataAccess.deleteVip(vip.getServiceId(), vip.getVipId());
    }
}

