/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.HostVipBaseAction;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostVipDisableAction
extends HostVipBaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostVipDisableAction.class);

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Enabling vips for {} {}", (Object)workItem.getHost().hostName, (Object)workItem.getService().serviceName);
        return Result.success;
    }

    @Override
    public Result processCallback(WorkItem workItem, CallbackData callbackData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Result processVip(WorkItem workItem, Vip vip) {
        LOGGER.info("Disabling vip {} for {} {}", new Object[]{vip.getDns(), workItem.getHost().hostName, workItem.getService().serviceName});
        return Result.success;
    }

    @Override
    protected String getVerb() {
        return "disable";
    }

    @Override
    protected String getVerbPastTense() {
        return "disabled";
    }

    @Override
    protected String getPreposition() {
        return "in";
    }
}

