/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDeployAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostDeployAction.class);

    @Override
    public Result process(WorkItem workItem) {
        LOGGER.info("Deploying to host {} of {}", (Object)workItem.getHost().hostName, (Object)workItem.getService().serviceName);
        Result result = Result.success;
        this.success(workItem);
        this.recordAudit(workItem, result, null);
        return result;
    }

    @Override
    public Result processCallback(WorkItem workItem, CallbackData callbackData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void updateStatusBeforeProcessing(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being deployed too", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus(true, "Deploying...");
        this.dataAccess.updateHost(host);
    }

    protected void recordAudit(WorkItem workItem, Result result, String output) {
        HashMap<String, String> notes = new HashMap<String, String>();
        if (workItem.getHost().version != null) {
            notes.put("Version", workItem.getHost().version);
        }
        if (workItem.getHost().prevVersion != null) {
            notes.put("Prev Version", workItem.getHost().prevVersion);
        }
        if (workItem.getHost().versionUrl != null) {
            notes.put("Version Url", workItem.getHost().versionUrl);
        }
        if (workItem.getHost().configVersion != null) {
            notes.put("Config_Version", workItem.getHost().configVersion);
        }
        notes.put("Reason", workItem.getHost().reason);
        this.recordAudit(workItem, result, notes, output);
    }

    protected void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being deployed too", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus(false, "-");
        this.dataAccess.updateHost(host);
    }

    protected void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being deployed too", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus(false, "Last deployment failed");
        this.dataAccess.updateHost(host);
    }
}

