/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDeleteAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostDeleteAction.class);

    @Override
    public Result process(WorkItem workItem) {
        Result result = Result.success;
        this.success(workItem);
        this.recordAudit(workItem, result, null);
        return result;
    }

    @Override
    public Result processCallback(WorkItem workItem, CallbackData callbackData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void recordAudit(WorkItem workItem, Result result, String output) {
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("Reason", workItem.getHost().reason);
        this.recordAudit(workItem, result, notes, output);
    }

    protected void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being delete.", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.deleteHost(host);
    }

    protected void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being delete.", (Object)workItem.getHost().hostId);
            return;
        }
        host.setStatus(false, "Delete host failed");
        this.dataAccess.updateHost(host);
    }
}

