/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.action.HostCreateAction;
import com.northernwall.hadrian.workItem.action.HostDeleteAction;
import com.northernwall.hadrian.workItem.action.HostDeployAction;
import com.northernwall.hadrian.workItem.action.HostRestartAction;
import com.northernwall.hadrian.workItem.action.HostVipDisableAction;
import com.northernwall.hadrian.workItem.action.HostVipEnableAction;
import com.northernwall.hadrian.workItem.action.ModuleCreateAction;
import com.northernwall.hadrian.workItem.action.ModuleDeleteAction;
import com.northernwall.hadrian.workItem.action.ModuleUpdateAction;
import com.northernwall.hadrian.workItem.action.VipCreateAction;
import com.northernwall.hadrian.workItem.action.VipDeleteAction;
import com.northernwall.hadrian.workItem.action.VipFixAction;
import com.northernwall.hadrian.workItem.action.VipUpdateAction;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dsh.metrics.MetricRegistry;
import org.dsh.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkItemProcessor.class);
    private final Parameters parameters;
    private final ConfigHelper configHelper;
    private final DataAccess dataAccess;
    private final OkHttpClient client;
    private final Gson gson;
    private final MetricRegistry metricRegistry;
    private final Action moduleCreate;
    private final Action moduleUpdate;
    private final Action moduleDelete;
    private final Action hostCreate;
    private final Action hostDeploy;
    private final Action hostRestart;
    private final Action hostDelete;
    private final Action vipCreate;
    private final Action vipUpdate;
    private final Action vipDelete;
    private final Action vipFix;
    private final Action hostVipEnable;
    private final Action hostVipDisable;
    private final Action hostVipAdd;
    private final Action hostVipRemove;
    private final ExecutorService executor;

    public WorkItemProcessor(Parameters parameters, ConfigHelper configHelper, DataAccess dataAccess, OkHttpClient client, Gson gson, MetricRegistry metricRegistry) {
        this.parameters = parameters;
        this.configHelper = configHelper;
        this.dataAccess = dataAccess;
        this.client = client;
        this.gson = gson;
        this.metricRegistry = metricRegistry;
        this.moduleCreate = this.constructAction("moduleCreate", ModuleCreateAction.class);
        this.moduleUpdate = this.constructAction("moduleUpdate", ModuleUpdateAction.class);
        this.moduleDelete = this.constructAction("moduleDelete", ModuleDeleteAction.class);
        this.hostCreate = this.constructAction("hostCreate", HostCreateAction.class);
        this.hostDeploy = this.constructAction("hostDeploy", HostDeployAction.class);
        this.hostRestart = this.constructAction("hostRestart", HostRestartAction.class);
        this.hostDelete = this.constructAction("hostDelete", HostDeleteAction.class);
        this.vipCreate = this.constructAction("vipCreate", VipCreateAction.class);
        this.vipUpdate = this.constructAction("vipUpdate", VipUpdateAction.class);
        this.vipDelete = this.constructAction("vipDelete", VipDeleteAction.class);
        this.vipFix = this.constructAction("vipFix", VipFixAction.class);
        this.hostVipEnable = this.constructAction("hostVipEnable", HostVipEnableAction.class);
        this.hostVipDisable = this.constructAction("hostVipDisable", HostVipDisableAction.class);
        this.hostVipAdd = this.constructAction("hostVipAdd", HostVipDisableAction.class);
        this.hostVipRemove = this.constructAction("hostVipRemove", HostVipDisableAction.class);
        this.executor = Executors.newFixedThreadPool(10);
    }

    private Action constructAction(String name, Class defaultClass) {
        String factoryName = this.parameters.getString("action." + name, null);
        try {
            Class<?> c;
            if (factoryName != null && !factoryName.isEmpty()) {
                c = Class.forName(factoryName);
            } else {
                c = defaultClass;
                factoryName = defaultClass.getName();
            }
            Action action = (Action)c.newInstance();
            action.init(name, this.dataAccess, this.parameters, this.configHelper, this.client, this.gson);
            LOGGER.info("Constructed action {} with {}", (Object)name, (Object)factoryName);
            return action;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not build Action " + name + ", could not find class " + factoryName, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Could not build Action " + name + ", could not instantiation class " + factoryName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not build Action " + name + ", could not access class " + factoryName, ex);
        }
    }

    public void processWorkItem(WorkItem workItem) throws IOException {
        if (workItem == null) {
            return;
        }
        workItem.setNextId(null);
        this.dataAccess.saveWorkItem(workItem);
        this.executor.submit(() -> this.process(workItem));
    }

    public void processWorkItems(List<WorkItem> workItems) throws IOException {
        if (workItems == null || workItems.isEmpty()) {
            return;
        }
        if (workItems.size() == 1) {
            this.processWorkItem(workItems.get(0));
            return;
        }
        int size = workItems.size();
        for (int i = 0; i < size; ++i) {
            WorkItem workItem = workItems.get(i);
            if (i == size - 1) {
                workItem.setNextId(null);
            } else {
                workItem.setNextId(workItems.get(i + 1).getId());
            }
            this.dataAccess.saveWorkItem(workItem);
        }
        this.executor.submit(() -> this.process((WorkItem)workItems.get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(WorkItem workItem) {
        Action action = this.getAction(workItem);
        Result result = Result.error;
        Timer timer = this.metricRegistry.timer("action-process", "action", action.getName());
        try {
            result = action.process(workItem);
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Failure while performing action {}, {}", (Object)action.getName(), (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                timer.stop("result", result.toString());
                throw throwable;
            }
            timer.stop("result", result.toString());
        }
        timer.stop("result", result.toString());
        switch (result) {
            case success: {
                LOGGER.info("Work item {} has been successfully processed, no callback expected. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 200);
                this.startNext(workItem);
                break;
            }
            case error: {
                LOGGER.warn("Work item {} failed to be process, no callback expected. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 502);
                this.stopNext(workItem);
                break;
            }
            case wip: {
                LOGGER.info("Work item {} is being processed, waiting for callback. {}", (Object)action.getName(), (Object)workItem.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCallback(CallbackData callbackData) {
        WorkItem workItem = this.dataAccess.getWorkItem(callbackData.requestId);
        Action action = this.getAction(workItem);
        Result result = Result.error;
        Timer timer = this.metricRegistry.timer("action-processCallback", "action", action.getName());
        try {
            result = action.processCallback(workItem, callbackData);
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Failure while performing action calback {}, {}", (Object)action.getName(), (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                timer.stop("result", result.toString());
                throw throwable;
            }
            timer.stop("result", result.toString());
        }
        timer.stop("result", result.toString());
        switch (result) {
            case success: {
                LOGGER.info("Work item {} has been successfully processed. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 200);
                this.startNext(workItem);
                break;
            }
            case error: {
                LOGGER.warn("Work item {} failed to be process. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 502);
                this.stopNext(workItem);
                break;
            }
            case wip: {
                LOGGER.info("Work item {} is still being processed. {}", (Object)action.getName(), (Object)workItem.getId());
            }
        }
    }

    public int waitForProcess(String lastId, long step, long max, String note) {
        LOGGER.info("Waiting for deployment, {}", (Object)note);
        long total = 0L;
        while (total < max) {
            int workItemStatus;
            total += step;
            try {
                Thread.sleep(step);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((workItemStatus = this.dataAccess.getWorkItemStatus(lastId)) <= 0) continue;
            LOGGER.info("Waiting done, status {}, {}", (Object)workItemStatus, (Object)note);
            return workItemStatus;
        }
        LOGGER.warn("Done waiting, but work items are not done, {}", (Object)note);
        return 500;
    }

    private Action getAction(WorkItem workItem) {
        switch (workItem.getType()) {
            case module: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.moduleCreate;
                    }
                    case update: {
                        return this.moduleUpdate;
                    }
                    case delete: {
                        return this.moduleDelete;
                    }
                }
            }
            case host: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.hostCreate;
                    }
                    case deploy: {
                        return this.hostDeploy;
                    }
                    case restart: {
                        return this.hostRestart;
                    }
                    case enableVips: {
                        return this.hostVipEnable;
                    }
                    case disableVips: {
                        return this.hostVipDisable;
                    }
                    case addVips: {
                        return this.hostVipAdd;
                    }
                    case removeVips: {
                        return this.hostVipRemove;
                    }
                    case delete: {
                        return this.hostDelete;
                    }
                }
            }
            case vip: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.vipCreate;
                    }
                    case update: {
                        return this.vipUpdate;
                    }
                    case delete: {
                        return this.vipDelete;
                    }
                    case fix: {
                        return this.vipFix;
                    }
                }
            }
        }
        throw new RuntimeException("Unknown work item - " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
    }

    private void startNext(WorkItem workItem) {
        String nextId = workItem.getNextId();
        if (nextId == null || nextId.isEmpty()) {
            return;
        }
        WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
        this.process(nextWorkItem);
    }

    private void stopNext(WorkItem workItem) {
        Host host;
        String nextId = workItem.getNextId();
        if (nextId == null || nextId.isEmpty()) {
            return;
        }
        WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
        this.stopNext(nextWorkItem);
        if (nextWorkItem.getType() == Type.host && (host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId)) != null) {
            host.setStatus(false, "Last operation cancelled");
            this.dataAccess.updateHost(host);
        }
        this.dataAccess.deleteWorkItem(nextId);
        this.dataAccess.saveWorkItemStatus(nextId, 502);
    }
}

