/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleFile;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.BasicHandler;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertHandler.class);

    public ConvertHandler(DataAccess dataAccess) {
        super(dataAccess);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    private void convertNetwork(String oldValue, String newValue) {
        List<Service> services = this.getDataAccess().getActiveServices();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                List<Vip> list;
                List<Host> hosts;
                List<Module> modules = this.getDataAccess().getModules(service.getServiceId());
                if (modules != null && !modules.isEmpty()) {
                    for (Module module : modules) {
                        List<ModuleFile> moduleFiles;
                        if (module.getNetworkNames() != null && !module.getNetworkNames().isEmpty() && module.getNetworkNames().containsKey(oldValue)) {
                            boolean value = module.getNetworkNames().get(oldValue);
                            LOGGER.info("Found a module with '{}' network, {} in {} with value {}", new Object[]{oldValue, module.getModuleName(), service.getServiceName(), value});
                            module.getNetworkNames().put(newValue, value);
                            module.getNetworkNames().remove(oldValue);
                            this.getDataAccess().saveModule(module);
                        }
                        if ((moduleFiles = this.getDataAccess().getModuleFiles(service.getServiceId(), module.getModuleId(), oldValue)) == null || moduleFiles.isEmpty()) continue;
                        for (ModuleFile moduleFile : moduleFiles) {
                            LOGGER.info("Found a module file with '{}' network, {} in {}", new Object[]{oldValue, module.getModuleName(), service.getServiceName()});
                            moduleFile.setNetwork(newValue);
                            this.getDataAccess().saveModuleFile(moduleFile);
                        }
                    }
                }
                if ((hosts = this.getDataAccess().getHosts(service.getServiceId())) != null && !hosts.isEmpty()) {
                    for (Host host : hosts) {
                        if (!host.getNetwork().equals(oldValue)) continue;
                        LOGGER.info("Found a host with '{}' network, {} in {}", new Object[]{oldValue, host.getHostName(), service.getServiceName()});
                        host.setNetwork(newValue);
                        this.getDataAccess().saveHost(host);
                    }
                }
                if ((list = this.getDataAccess().getVips(service.getServiceId())) == null || list.isEmpty()) continue;
                for (Vip vip : list) {
                    if (!vip.getNetwork().equals(oldValue)) continue;
                    LOGGER.info("Found a VIP with '{}' network, {} in {}", new Object[]{oldValue, vip.getDns(), service.getServiceName()});
                    vip.setNetwork(newValue);
                    this.getDataAccess().saveVip(vip);
                }
            }
        }
    }
}

