/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.team;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.team.dao.DeleteTeamRemoveUserData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http405NotAllowedException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class TeamRemoveUserHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public TeamRemoveUserHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteTeamRemoveUserData data = this.fromJson(request, DeleteTeamRemoveUserData.class);
        Team team = this.getTeam(data.teamId, null);
        this.accessHelper.checkIfUserCanModify(request, data.teamId, "remove user from team");
        if (team.getUsernames().size() < 2) {
            throw new Http405NotAllowedException("Can not remove the last user from team " + team.getTeamName());
        }
        if (team.getUsernames().contains(data.username)) {
            team.getUsernames().remove(data.username);
            this.getDataAccess().updateTeam(team);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

