/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service.dao;

import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.service.dao.GetDataStoreData;
import com.northernwall.hadrian.handlers.service.dao.GetHostData;
import com.northernwall.hadrian.handlers.service.dao.GetModuleData;
import com.northernwall.hadrian.handlers.service.dao.GetNetworkData;
import com.northernwall.hadrian.handlers.service.dao.GetVipData;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class GetServiceData {
    public String serviceId;
    public String serviceName;
    public String teamId;
    public String description;
    public String serviceType;
    public String gitProject;
    public String scope;
    public String mavenGroupId;
    public String testStyle;
    public String testHostname;
    public String testRunAs;
    public String testDeploymentFolder;
    public String testCmdLine;
    public List<Document> leftDocuments;
    public List<Document> middleDocuments;
    public List<Document> rightDocuments;
    public Date creationDate;
    public Date deletionDate;
    public boolean active;
    public List<GetModuleData> modules;
    public List<GetNetworkData> networks;
    public List<GetDataStoreData> dataStores;
    public boolean canModify;

    public static GetServiceData create(Service service) {
        GetServiceData temp = new GetServiceData();
        temp.serviceId = service.getServiceId();
        temp.serviceName = service.getServiceName();
        temp.teamId = service.getTeamId();
        temp.description = service.getDescription();
        temp.serviceType = service.getServiceType();
        temp.gitProject = service.getGitProject();
        temp.scope = service.getScope();
        temp.mavenGroupId = service.getMavenGroupId();
        temp.testStyle = service.getTestStyle();
        temp.testHostname = service.getTestHostname();
        temp.testRunAs = service.getTestRunAs();
        temp.testDeploymentFolder = service.getTestDeploymentFolder();
        temp.testCmdLine = service.getTestCmdLine();
        temp.leftDocuments = new LinkedList<Document>();
        temp.middleDocuments = new LinkedList<Document>();
        temp.rightDocuments = new LinkedList<Document>();
        Collections.sort(service.getDocuments());
        for (Document doc : service.getDocuments()) {
            if (temp.middleDocuments.size() == temp.rightDocuments.size()) {
                if (temp.leftDocuments.size() == temp.middleDocuments.size()) {
                    temp.leftDocuments.add(doc);
                    continue;
                }
                temp.middleDocuments.add(doc);
                continue;
            }
            temp.rightDocuments.add(doc);
        }
        temp.creationDate = service.getCreationDate();
        temp.deletionDate = service.getDeletionDate();
        temp.active = service.isActive();
        temp.modules = new LinkedList<GetModuleData>();
        temp.networks = new LinkedList<GetNetworkData>();
        temp.dataStores = new LinkedList<GetDataStoreData>();
        return temp;
    }

    public void addNetwork(String network) {
        for (GetNetworkData networkData : this.networks) {
            if (!networkData.network.equals(network)) continue;
            return;
        }
        GetNetworkData networkData = new GetNetworkData();
        networkData.network = network;
        this.networks.add(networkData);
    }

    public void addModuleNetwork(Module module, String network) {
        for (GetNetworkData networkData : this.networks) {
            if (!networkData.network.equals(network)) continue;
            networkData.addModule(module);
            return;
        }
    }

    public void addHost(GetHostData hostData, GetModuleData moduleData) {
        for (GetNetworkData networkData : this.networks) {
            if (!networkData.network.equals(hostData.network)) continue;
            networkData.addHost(hostData, moduleData);
            return;
        }
    }

    public void addVip(GetVipData vipData, GetModuleData moduleData) {
        for (GetNetworkData networkData : this.networks) {
            if (!networkData.network.equals(vipData.network)) continue;
            networkData.addVip(vipData, moduleData);
            return;
        }
    }
}

