/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.DeleteServiceRefData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceRefDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ServiceRefDeleteHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteServiceRefData data = this.fromJson(request, DeleteServiceRefData.class);
        Service clientService = this.getService(data.clientServiceId, null);
        User user = this.accessHelper.checkIfUserCanModify(request, clientService.getTeamId(), "delete a module ref");
        Module clientModule = this.getModule(data.clientModuleId, null, clientService);
        Service serverService = this.getService(data.serverServiceId, null);
        Module serverModule = this.getModule(data.serverModuleId, null, serverService);
        this.getDataAccess().deleteModuleRef(data.clientServiceId, data.clientModuleId, data.serverServiceId, data.serverModuleId);
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("Uses", serverService.getServiceName() + " " + serverModule.getModuleName());
        this.createAudit(data.clientServiceId, clientModule.getModuleName(), user.getUsername(), notes);
        notes = new HashMap();
        notes.put("Use_By", clientService.getServiceName() + " " + clientModule.getModuleName());
        this.createAudit(data.serverServiceId, serverModule.getModuleName(), user.getUsername(), notes);
        response.setStatus(200);
        request.setHandled(true);
    }

    private void createAudit(String serviceId, String moduleName, String requestor, Map<String, String> notes) {
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.moduleName = moduleName;
        audit.setTimePerformed(GMT.getGmtAsDate());
        audit.timeRequested = GMT.getGmtAsDate();
        audit.requestor = requestor;
        audit.type = Type.serviceRef;
        audit.operation = Operation.delete;
        audit.successfull = true;
        audit.notes = ServiceRefDeleteHandler.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

