/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutServiceData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http405NotAllowedException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceModifyHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ServiceModifyHandler(AccessHelper accessHelper, DataAccess dataAccess) {
        super(dataAccess);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutServiceData data = this.fromJson(request, PutServiceData.class);
        Service service = this.getService(data.serviceId, null);
        this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "modify a service");
        for (Service temp : this.getDataAccess().getActiveServices()) {
            if (!temp.getServiceName().equalsIgnoreCase(data.serviceName) || temp.getServiceId().equals(data.serviceId)) continue;
            throw new Http405NotAllowedException("A service already exists with this name");
        }
        Service tempService = this.getDataAccess().getServiceByServiceName(data.serviceName);
        if (tempService != null && !tempService.getServiceId().equals(data.serviceId)) {
            throw new Http405NotAllowedException("A service already exists with this name");
        }
        if (data.testStyle.equals("Maven")) {
            data.testHostname = null;
            data.testRunAs = null;
            data.testDeploymentFolder = null;
            data.testCmdLine = null;
        }
        service.setServiceName(data.serviceName);
        service.setDescription(data.description);
        service.setScope(data.scope);
        service.setTestStyle(data.testStyle);
        service.setTestHostname(data.testHostname);
        service.setTestRunAs(data.testRunAs);
        service.setTestDeploymentFolder(data.testDeploymentFolder);
        service.setTestCmdLine(data.testCmdLine);
        this.getDataAccess().updateService(service);
        response.setStatus(200);
        request.setHandled(true);
    }
}

