/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.ModuleCreateHandler;
import com.northernwall.hadrian.handlers.service.dao.PutModuleData;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleModifyHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleModifyHandler.class);
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public ModuleModifyHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutModuleData data = this.fromJson(request, PutModuleData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, service.getTeamId(), "update module");
        List<Host> hosts = this.getDataAccess().getHosts(data.serviceId);
        for (Host host : hosts) {
            Boolean temp;
            if (!host.getModuleId().equals(data.moduleId) || (temp = data.networkNames.get(host.getNetwork())) != null && temp.booleanValue()) continue;
            throw new Http400BadRequestException("Can not remove a network from a module with an active host");
        }
        List<Vip> vips = this.getDataAccess().getVips(data.serviceId);
        for (Vip vip : vips) {
            Object temp;
            if (!vip.getModuleId().equals(data.moduleId) || (temp = data.networkNames.get(vip.getNetwork())) != null && ((Boolean)temp).booleanValue()) continue;
            throw new Http400BadRequestException("Can not remove a network from a module with an active VIP");
        }
        List<Module> list = this.getDataAccess().getModules(data.serviceId);
        Module module = null;
        for (Module temp : list) {
            if (!temp.getModuleId().equals(data.moduleId)) continue;
            module = temp;
        }
        if (module == null) {
            LOGGER.warn("Could not find module with id {} in service {}", (Object)data.moduleId, (Object)data.serviceId);
            return;
        }
        switch (module.getModuleType()) {
            case Library: {
                data.outbound = "No";
                data.hostAbbr = "";
                data.versionUrl = "";
                data.availabilityUrl = "";
                data.runAs = "";
                data.deploymentFolder = "";
                data.dataFolder = "";
                data.logsFolder = "";
                data.startCmdLine = "";
                data.startTimeOut = 0;
                data.stopCmdLine = "";
                data.stopTimeOut = 0;
                break;
            }
            case Simulator: {
                data.outbound = "No";
            }
            case Deployable: {
                if (data.hostAbbr.contains("-")) {
                    throw new Http400BadRequestException("Can not have '-' in host abbr");
                }
                data.deploymentFolder = ModuleCreateHandler.scrubFolder(data.deploymentFolder, "deploy", false);
                data.logsFolder = ModuleCreateHandler.scrubFolder(data.logsFolder, "logs", false);
                if (ModuleCreateHandler.isSubFolder(data.logsFolder, data.deploymentFolder)) {
                    throw new Http400BadRequestException("Log folder can not be a sub folder of the deployment folder");
                }
                data.dataFolder = ModuleCreateHandler.scrubFolder(data.dataFolder, "data", true);
                if (data.dataFolder == null || !ModuleCreateHandler.isSubFolder(data.dataFolder, data.deploymentFolder)) break;
                throw new Http400BadRequestException("Data folder can not be a sub folder of the deployment folder");
            }
        }
        module.setModuleName(data.moduleName);
        module.setGitFolder(data.gitFolder);
        module.setMavenArtifactId(data.mavenArtifactId);
        module.setArtifactType(data.artifactType);
        module.setArtifactSuffix(data.artifactSuffix);
        module.setOutbound(data.outbound);
        module.setHostAbbr(data.hostAbbr.toLowerCase());
        module.setVersionUrl(data.versionUrl);
        module.setAvailabilityUrl(data.availabilityUrl);
        module.setRunAs(data.runAs);
        module.setDeploymentFolder(data.deploymentFolder);
        module.setDataFolder(data.dataFolder);
        module.setLogsFolder(data.logsFolder);
        module.setLogsRetention(data.logsRetention);
        module.setStartCmdLine(data.startCmdLine);
        module.setStartTimeOut(data.startTimeOut);
        module.setStopCmdLine(data.stopCmdLine);
        module.setStopTimeOut(data.stopTimeOut);
        module.setConfigName(data.configName);
        module.setNetworkNames(data.networkNames);
        module.cleanNetworkNames(null);
        this.getDataAccess().saveModule(module);
        WorkItem workItem = new WorkItem(Type.module, Operation.update, user, team, service, module, null, null);
        for (Module temp : list) {
            workItem.addModule(temp);
        }
        this.workItemProcessor.processWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

