/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutRestartHostData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostRestartHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public HostRestartHandler(AccessHelper accessHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutRestartHostData data = this.fromJson(request, PutRestartHostData.class);
        Service service = this.getService(data.serviceId, data.serviceName);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanRestart(request, service.getTeamId());
        Module module = this.getModule(data.moduleId, data.moduleName, service);
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(hosts.size());
        for (Host host : hosts) {
            if (!host.getModuleId().equals(module.getModuleId()) || !host.getNetwork().equals(data.network) || !data.all && !data.hostNames.contains(host.getHostName()) || host.isBusy()) continue;
            if (workItems.isEmpty()) {
                host.setStatus(true, "Restarting...");
            } else {
                host.setStatus(true, "Restart Queued");
            }
            this.getDataAccess().updateHost(host);
            WorkItem workItem = new WorkItem(Type.host, Operation.disableVips, user, team, service, module, host, null);
            workItems.add(workItem);
            workItem = new WorkItem(Type.host, Operation.restart, user, team, service, module, host, null);
            workItem.getHost().reason = data.reason;
            workItems.add(workItem);
            workItem = new WorkItem(Type.host, Operation.enableVips, user, team, service, module, host, null);
            workItems.add(workItem);
        }
        this.workItemProcessor.processWorkItems(workItems);
        int status = 200;
        if (data.wait) {
            status = this.workItemProcessor.waitForProcess(((WorkItem)workItems.get(workItems.size() - 1)).getId(), (module.getStartTimeOut() + module.getStopTimeOut()) * 100, workItems.size() * (module.getStartTimeOut() + module.getStopTimeOut()) * 1500, service.getServiceName() + " " + module.getModuleName());
        }
        response.setStatus(status);
        request.setHandled(true);
    }
}

