/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Network;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.PutDeploySoftwareData;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import com.northernwall.hadrian.handlers.utility.routingHandler.Http400BadRequestException;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostDeploySoftwareHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;
    private final InfoHelper infoHelper;
    private final WorkItemProcessor workItemProcessor;

    public HostDeploySoftwareHandler(AccessHelper accessHelper, ConfigHelper configHelper, InfoHelper infoHelper, DataAccess dataAccess, WorkItemProcessor workItemProcessor) {
        super(dataAccess);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.infoHelper = infoHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutDeploySoftwareData data = this.fromJson(request, PutDeploySoftwareData.class);
        Service service = this.getService(data.serviceId, data.serviceName);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanDeploy(request, service.getTeamId());
        Module module = this.getModule(data.moduleId, data.moduleName, service);
        Network network = null;
        for (Network temp : this.configHelper.getConfig().networks) {
            if (!temp.name.equals(data.network)) continue;
            network = temp;
        }
        if (network == null) {
            throw new Http400BadRequestException("Unknown network " + data.network);
        }
        if (!network.allowUrl && data.versionUrl != null) {
            throw new Http400BadRequestException("Network " + network.name + " does not allow versionUrl");
        }
        if (data.version != null && data.versionUrl != null) {
            throw new Http400BadRequestException("Only one of version and versionUrl can be specified");
        }
        if ((data.version == null || data.version.isEmpty()) && (data.versionUrl == null || data.versionUrl.isEmpty())) {
            throw new Http400BadRequestException("One of version and versionUrl must be specified");
        }
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(hosts.size());
        for (Host host : hosts) {
            if (!host.getModuleId().equals(module.getModuleId()) || !host.getNetwork().equals(data.network) || !data.all && !data.hostNames.contains(host.getHostName()) || host.isBusy()) continue;
            if (workItems.isEmpty()) {
                host.setStatus(true, "Deploying...");
            } else {
                host.setStatus(true, "Deploy Queued");
            }
            this.getDataAccess().updateHost(host);
            WorkItem workItem = new WorkItem(Type.host, Operation.disableVips, user, team, service, module, host, null);
            workItems.add(workItem);
            workItem = new WorkItem(Type.host, Operation.deploy, user, team, service, module, host, null);
            workItem.getHost().version = data.version;
            workItem.getHost().prevVersion = this.infoHelper.readVersion(host.getHostName(), module.getVersionUrl());
            workItem.getHost().versionUrl = data.versionUrl;
            workItem.getHost().configVersion = data.configVersion;
            workItem.getHost().reason = data.reason;
            workItems.add(workItem);
            workItem = new WorkItem(Type.host, Operation.enableVips, user, team, service, module, host, null);
            workItems.add(workItem);
        }
        this.workItemProcessor.processWorkItems(workItems);
        int status = 200;
        if (data.wait) {
            status = this.workItemProcessor.waitForProcess(((WorkItem)workItems.get(workItems.size() - 1)).getId(), module.getStartTimeOut() * 100, workItems.size() * module.getStartTimeOut() * 1500, service.getServiceName() + " " + module.getModuleName() + " " + data.version);
        }
        response.setStatus(status);
        request.setHandled(true);
    }
}

