/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CalendarEntry;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.service.dao.GetCalendarData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class CalendarGetHandler
extends BasicHandler {
    private final CalendarHelper calendarHelper;

    public CalendarGetHandler(DataAccess dataAccess, CalendarHelper calendarHelper) {
        super(dataAccess);
        this.calendarHelper = calendarHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        Team team = this.getDataAccess().getTeam(service.getTeamId());
        GetCalendarData data = new GetCalendarData();
        data.entries = this.calendarHelper.getCalendarEntries(team);
        if (data.entries == null) {
            data.entries = new LinkedList<CalendarEntry>();
        }
        if (data.entries.isEmpty()) {
            CalendarEntry entry = new CalendarEntry();
            entry.calendarName = "-";
            entry.starts = "-";
            entry.ends = "-";
            entry.description = "-";
            data.entries.add(entry);
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            CalendarGetHandler.getGson().toJson((Object)data, GetCalendarData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

