/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.graph;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.graph.Graph;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class GraphFanOutHandler
extends AbstractHandler {
    private final DataAccess dataAccess;

    public GraphFanOutHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String serviceId = target.substring(17);
        response.setContentType("text/plain; charset=utf-8");
        Graph graph = new Graph((OutputStream)response.getOutputStream(), false);
        LinkedList<Module> modules = new LinkedList<Module>();
        LinkedList<String> foundIds = new LinkedList<String>();
        Service service = this.dataAccess.getService(serviceId);
        Team team = this.dataAccess.getTeam(service.getTeamId());
        for (Module module : this.dataAccess.getModules(serviceId)) {
            if (module.getModuleType() != ModuleType.Test) {
                this.fanOut(module, graph, modules, foundIds, false);
                graph.writeModule(module, team.getColour());
            }
            foundIds.add(module.getModuleId());
        }
        while (!modules.isEmpty()) {
            Module module = (Module)modules.remove(0);
            if (module.getModuleType() != ModuleType.Test) {
                this.fanOut(module, graph, modules, foundIds, true);
                service = this.dataAccess.getService(module.getServiceId());
                team = this.dataAccess.getTeam(service.getTeamId());
                graph.writeModule(module, team.getColour());
            }
            foundIds.add(module.getModuleId());
        }
        graph.close();
        request.setHandled(true);
        response.setStatus(200);
    }

    private void fanOut(Module module, Graph graph, List<Module> modules, List<String> foundIds, boolean checkFound) throws IOException {
        List<ModuleRef> moduleRefs = this.dataAccess.getModuleRefsByClient(module.getServiceId(), module.getModuleId());
        if (moduleRefs != null && !moduleRefs.isEmpty()) {
            for (ModuleRef moduleRef : moduleRefs) {
                if (checkFound && foundIds.contains(moduleRef.getServerModuleId())) continue;
                Module temp = this.dataAccess.getModule(moduleRef.getServerServiceId(), moduleRef.getServerModuleId());
                graph.writeLink(module.getModuleName(), temp.getModuleName());
                if (!checkFound && temp.getServiceId().equals(module.getServiceId())) continue;
                modules.add(temp);
            }
        }
    }
}

